/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedMethod;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.c.function.CodePointer;

public class FrameInfoQueryResult {
    protected FrameInfoQueryResult caller;
    protected SharedMethod deoptMethod;
    protected int deoptMethodOffset;
    protected long encodedBci;
    protected boolean isDeoptEntry;
    protected boolean needLocalValues;
    protected int numLocals;
    protected int numStack;
    protected int numLocks;
    protected ValueInfo[] valueInfos;
    protected ValueInfo[][] virtualObjects;
    protected Class<?> sourceClass;
    protected String sourceMethodName;
    protected int sourceLineNumber;
    protected int sourceClassIndex;
    protected int sourceMethodNameIndex;

    public FrameInfoQueryResult() {
        this.init();
    }

    public void init() {
        this.caller = null;
        this.deoptMethod = null;
        this.deoptMethodOffset = 0;
        this.encodedBci = 0L;
        this.isDeoptEntry = false;
        this.needLocalValues = false;
        this.numLocals = 0;
        this.numStack = 0;
        this.numLocks = 0;
        this.valueInfos = null;
        this.virtualObjects = null;
        this.sourceClass = null;
        this.sourceMethodName = "";
        this.sourceLineNumber = -1;
        this.sourceClassIndex = -1;
        this.sourceMethodNameIndex = -1;
    }

    public FrameInfoQueryResult getCaller() {
        return this.caller;
    }

    public SharedMethod getDeoptMethod() {
        return this.deoptMethod;
    }

    public int getDeoptMethodOffset() {
        return this.deoptMethodOffset;
    }

    public CodePointer getDeoptMethodAddress() {
        return CodeInfoTable.getImageCodeCache().absoluteIP(this.deoptMethodOffset);
    }

    public long getEncodedBci() {
        return this.encodedBci;
    }

    public int getBci() {
        return FrameInfoDecoder.decodeBci(this.encodedBci);
    }

    public boolean isDeoptEntry() {
        return this.isDeoptEntry;
    }

    public int getNumLocals() {
        return this.numLocals;
    }

    public int getNumLocks() {
        return this.numLocks;
    }

    public int getNumStack() {
        return this.numStack;
    }

    public ValueInfo[] getValueInfos() {
        return this.valueInfos;
    }

    public ValueInfo[][] getVirtualObjects() {
        return this.virtualObjects;
    }

    public Class<?> getSourceClass() {
        return this.sourceClass;
    }

    public String getSourceClassName() {
        return this.sourceClass != null ? this.sourceClass.getName() : "";
    }

    public String getSourceMethodName() {
        return this.sourceMethodName;
    }

    public String getSourceFileName() {
        return this.sourceClass != null ? DynamicHub.fromClass(this.sourceClass).getSourceFileName() : null;
    }

    public int getSourceLineNumber() {
        return this.sourceLineNumber;
    }

    public StackTraceElement getSourceReference() {
        String className = this.sourceClass != null ? this.sourceClass.getName() : "";
        String sourceFileName = this.sourceClass != null ? DynamicHub.fromClass(this.sourceClass).getSourceFileName() : null;
        return new StackTraceElement(className, this.sourceMethodName, sourceFileName, this.sourceLineNumber);
    }

    public boolean isNativeMethod() {
        return this.sourceLineNumber == -2;
    }

    public Log log(Log log) {
        String className = this.sourceClass != null ? this.sourceClass.getName() : "";
        String methodName = this.sourceMethodName != null ? this.sourceMethodName : "";
        log.string(className);
        if (!className.isEmpty() && !methodName.isEmpty()) {
            log.string(".");
        }
        log.string(methodName);
        if (this.isDeoptEntry()) {
            log.string("**");
        }
        log.string("(");
        if (this.isNativeMethod()) {
            log.string("Native Method");
        } else {
            String sourceFileName;
            String string = sourceFileName = this.sourceClass != null ? DynamicHub.fromClass(this.sourceClass).getSourceFileName() : null;
            if (sourceFileName != null) {
                if (this.sourceLineNumber >= 0) {
                    log.string(sourceFileName).string(":").signed(this.sourceLineNumber);
                } else {
                    log.string(sourceFileName);
                }
            } else {
                log.string("Unknown Source");
            }
        }
        log.string(")");
        return log;
    }

    public String getLocalVariableName(int idx) {
        return idx < this.valueInfos.length ? this.valueInfos[idx].name : null;
    }

    public static class ValueInfo {
        protected ValueType type;
        protected JavaKind kind;
        protected boolean isCompressedReference;
        protected long data;
        protected JavaConstant value;
        protected String name;
        protected int nameIndex = -1;

        public ValueType getType() {
            return this.type;
        }

        public JavaKind getKind() {
            return this.kind;
        }

        public boolean isCompressedReference() {
            return this.isCompressedReference;
        }

        public long getData() {
            return this.data;
        }

        public JavaConstant getValue() {
            return this.value;
        }
    }

    public static enum ValueType {
        Illegal(false),
        StackSlot(true),
        Constant(true),
        DefaultConstant(false),
        VirtualObject(true);

        protected final boolean hasData;

        private ValueType(boolean hasData) {
            this.hasData = hasData;
        }
    }
}

