/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11.darwin;

import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.posix.PosixJavaNetClose;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Socket;
import java.net.SocketException;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;

class Util_jdk_net_MacOSXSocketOptions {
    Util_jdk_net_MacOSXSocketOptions() {
    }

    static void handleError(int rv, String errmsg) throws SocketException {
        if (rv < 0) {
            if (Errno.errno() == Errno.ENOPROTOOPT()) {
                throw new UnsupportedOperationException("unsupported socket option");
            }
            throw new SocketException(PosixUtils.lastErrorString(errmsg));
        }
    }

    static int socketOptionSupported(int sockopt) {
        CIntPointer one_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        one_Pointer.write(1);
        int s = Socket.socket(Socket.PF_INET(), Socket.SOCK_STREAM(), NetinetIn.IPPROTO_TCP());
        if (s < 0) {
            return 0;
        }
        int rv = Socket.setsockopt(s, NetinetIn.IPPROTO_TCP(), sockopt, (PointerBase)one_Pointer, SizeOf.get(CIntPointer.class));
        rv = rv != 0 && Errno.errno() == Errno.ENOPROTOOPT() ? 0 : 1;
        ((PosixJavaNetClose)ImageSingletons.lookup(PosixJavaNetClose.class)).NET_SocketClose(s);
        return rv;
    }
}

