/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11.darwin;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.NetinetTcp;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.jdk11.darwin.Util_jdk_net_MacOSXSocketOptions;
import java.net.SocketException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;

@TargetClass(className="jdk.net.MacOSXSocketOptions", onlyWith={JDK11OrLater.class})
@Platforms(value={Platform.DARWIN_AMD64.class})
public final class Target_jdk_net_MacOSXSocketOptions {
    @Substitute
    private static int getTcpKeepAliveIntvl0(int fd) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_KEEPINTVL(), (PointerBase)optval_Pointer, sz_Pointer);
        Util_jdk_net_MacOSXSocketOptions.handleError(rv, "get option TCL_KEEPINTVL failed");
        return optval_Pointer.read();
    }

    @Substitute
    private static void setTcpKeepAliveIntvl0(int fd, int optval) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(optval);
        int rv = Socket.setsockopt(fd, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_KEEPINTVL(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        Util_jdk_net_MacOSXSocketOptions.handleError(rv, "set option TCL_KEEPINTVL failed");
    }

    @Substitute
    private static int getTcpKeepAliveTime0(int fd) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_KEEPALIVE(), (PointerBase)optval_Pointer, sz_Pointer);
        Util_jdk_net_MacOSXSocketOptions.handleError(rv, "get option TCP_KEEPALIVE failed");
        return optval_Pointer.read();
    }

    @Substitute
    private static void setTcpKeepAliveTime0(int fd, int optval) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(optval);
        int rv = Socket.setsockopt(fd, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_KEEPALIVE(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        Util_jdk_net_MacOSXSocketOptions.handleError(rv, "set option TCP_KEEPALIVE failed");
    }

    @Substitute
    private static int getTcpkeepAliveProbes0(int fd) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer sz_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        sz_Pointer.write(SizeOf.get(CIntPointer.class));
        int rv = Socket.getsockopt(fd, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_KEEPCNT(), (PointerBase)optval_Pointer, sz_Pointer);
        Util_jdk_net_MacOSXSocketOptions.handleError(rv, "get option TCP_KEEPCNT failed");
        return optval_Pointer.read();
    }

    @Substitute
    private static void setTcpkeepAliveProbes0(int fd, int optval) throws SocketException {
        CIntPointer optval_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        optval_Pointer.write(optval);
        int rv = Socket.setsockopt(fd, NetinetIn.IPPROTO_TCP(), NetinetTcp.TCP_KEEPCNT(), (PointerBase)optval_Pointer, SizeOf.get(CIntPointer.class));
        Util_jdk_net_MacOSXSocketOptions.handleError(rv, "set option TCP_KEEPCNT failed");
    }

    @Substitute
    private static boolean keepAliveOptionsSupported0() {
        return Util_jdk_net_MacOSXSocketOptions.socketOptionSupported(NetinetTcp.TCP_KEEPALIVE()) != 0 && Util_jdk_net_MacOSXSocketOptions.socketOptionSupported(NetinetTcp.TCP_KEEPCNT()) != 0 && Util_jdk_net_MacOSXSocketOptions.socketOptionSupported(NetinetTcp.TCP_KEEPINTVL()) != 0;
    }
}

