/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.jdk11;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Statvfs;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.FileDescriptor;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
public class PosixJavaNIOSubstitutions {

    @TargetClass(className="sun.nio.ch.FileDispatcherImpl", onlyWith={JDK11OrLater.class})
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    static final class Target_sun_nio_ch_FileDispatcherImpl {
        Target_sun_nio_ch_FileDispatcherImpl() {
        }

        @Substitute
        static int setDirect0(FileDescriptor fdo) throws IOException {
            int result;
            int fd = PosixUtils.getFD(fdo);
            Statvfs.statvfs file_stat = (Statvfs.statvfs)StackValue.get(Statvfs.statvfs.class);
            if (IsDefined.LINUX() || IsDefined.MACOSX()) {
                if (IsDefined.LINUX()) {
                    int orig_flag = Fcntl.fcntl(fd, Fcntl.F_GETFL());
                    if (orig_flag == -1) {
                        throw new IOException(PosixUtils.lastErrorString("DirectIO setup failed"));
                    }
                    result = Fcntl.fcntl(fd, Fcntl.F_SETFD(), orig_flag | Fcntl.O_DIRECT());
                    if (result == -1) {
                        throw new IOException(PosixUtils.lastErrorString("DirectIO setup failed"));
                    }
                } else if (IsDefined.MACOSX() && (result = Fcntl.fcntl(fd, Fcntl.F_NOCACHE(), 1)) == -1) {
                    throw new IOException(PosixUtils.lastErrorString("DirectIO setup failed"));
                }
                if ((result = Statvfs.fstatvfs(fd, file_stat)) == -1) {
                    throw new IOException(PosixUtils.lastErrorString("DirectIO setup failed"));
                }
                result = (int)file_stat.f_frsize();
            } else {
                result = -1;
            }
            return result;
        }
    }

    @TargetClass(className="sun.nio.ch.IOUtil", onlyWith={JDK11OrLater.class})
    @Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
    static final class Target_sun_nio_ch_IOUtil {
        Target_sun_nio_ch_IOUtil() {
        }

        @Substitute
        static int write1(int fd, byte b) throws IOException {
            CCharPointer c = (CCharPointer)StackValue.get(CCharPointer.class);
            c.write(b);
            return com.oracle.svm.core.posix.PosixJavaNIOSubstitutions.convertReturnVal((WordBase)Unistd.write(fd, (PointerBase)c, WordFactory.unsigned((int)1)), false);
        }
    }
}

