/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.jdk.ModuleUtils;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;
import sun.util.resources.TimeZoneNamesBundle;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Platforms(value={Platform.HOSTED_ONLY.class})
public class LocalizationResourceBundles
extends LocalizationSupport {
    private static final Method NEW_RESOURCE_BUNDLE;

    static void initialize(LocalizationSupport localizationSupport) {
        ModuleUtils.addOpensToAllUnnamed("java.base", "jdk.internal.misc");
        LocaleProviderAdapter.Type jreLocaleProviderAdapterType = LocaleProviderAdapter.Type.JRE;
        LocaleData jreLocaleData = new LocaleData(jreLocaleProviderAdapterType);
        Locale defaultLocale = Locale.getDefault();
        String calendarDataKey = jreLocaleProviderAdapterType.getUtilResourcesPackage() + ".CalendarData";
        ResourceBundle calendarDataBundle = jreLocaleData.getCalendarData(defaultLocale);
        localizationSupport.addBundleToCache(calendarDataKey, calendarDataBundle);
        String currencyNamesKey = jreLocaleProviderAdapterType.getUtilResourcesPackage() + ".CurrencyNames";
        OpenListResourceBundle currencyNamesBundle = jreLocaleData.getCurrencyNames(defaultLocale);
        localizationSupport.addBundleToCache(currencyNamesKey, currencyNamesBundle);
        String localeNamesKey = jreLocaleProviderAdapterType.getUtilResourcesPackage() + ".LocaleNames";
        OpenListResourceBundle localeNamesBundle = jreLocaleData.getLocaleNames(defaultLocale);
        localizationSupport.addBundleToCache(localeNamesKey, localeNamesBundle);
        String timeZoneNamesKey = jreLocaleProviderAdapterType.getUtilResourcesPackage() + ".TimeZoneNames";
        TimeZoneNamesBundle timeZoneNamesBundle = jreLocaleData.getTimeZoneNames(defaultLocale);
        localizationSupport.addBundleToCache(timeZoneNamesKey, timeZoneNamesBundle);
        TimeZone.getDefault().getDisplayName();
        String breakIteratorInfoKey = jreLocaleProviderAdapterType.getTextResourcesPackage() + ".BreakIteratorInfo";
        ResourceBundle breakIteratorInfoBundle = jreLocaleData.getBreakIteratorInfo(defaultLocale);
        localizationSupport.addBundleToCache(breakIteratorInfoKey, breakIteratorInfoBundle);
        String breakIteratorResourcesKey = jreLocaleProviderAdapterType.getTextResourcesPackage() + ".BreakIteratorResources";
        ResourceBundle breakIteratorResourcesBundle = jreLocaleData.getBreakIteratorResources(defaultLocale);
        localizationSupport.addBundleToCache(breakIteratorResourcesKey, breakIteratorResourcesBundle);
        String collationDataKey = jreLocaleProviderAdapterType.getTextResourcesPackage() + ".CollationData";
        ResourceBundle collationDataBundle = jreLocaleData.getCollationData(defaultLocale);
        localizationSupport.addBundleToCache(collationDataKey, collationDataBundle);
        String formatDataKey = jreLocaleProviderAdapterType.getTextResourcesPackage() + ".FormatData";
        ResourceBundle formatDataBundle = jreLocaleData.getDateFormatData(defaultLocale);
        localizationSupport.addBundleToCache(formatDataKey, formatDataBundle);
        LocaleProviderAdapter.Type cldrLocaleProviderAdapterType = LocaleProviderAdapter.Type.CLDR;
        LocaleData cldrLocaleData = new LocaleData(cldrLocaleProviderAdapterType);
        String cldrFormatDataKey = cldrLocaleProviderAdapterType.getTextResourcesPackage() + ".FormatData";
        ResourceBundle cldrFormatDataBundle = cldrLocaleData.getDateFormatData(defaultLocale);
        localizationSupport.addBundleToCache(cldrFormatDataKey, cldrFormatDataBundle);
        String sunUtilLoggingResourcesLoggingKey = "sun.util.logging.resources.logging";
        ResourceBundle sunUtilLoggingResourcesLoggingBundle = LocalizationResourceBundles.getBundleByName("sun.util.logging.resources.logging");
        localizationSupport.addBundleToCache("sun.util.logging.resources.logging", sunUtilLoggingResourcesLoggingBundle);
    }

    private static ResourceBundle getBundleByName(String bundleName) {
        Class<ResourceBundle> bundleClass = null;
        try {
            Class<?> fromName = Class.forName(bundleName);
            bundleClass = fromName.asSubclass(ResourceBundle.class);
        }
        catch (ClassNotFoundException cnfe) {
            throw VMError.shouldNotReachHere("Could not find ResourceBundle by name:", cnfe);
        }
        catch (ClassCastException cce) {
            throw VMError.shouldNotReachHere("Class is not a ResourceBundle:", cce);
        }
        try {
            return (ResourceBundle)NEW_RESOURCE_BUNDLE.invoke(null, bundleClass);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    static {
        try {
            NEW_RESOURCE_BUNDLE = ReflectionUtil.lookupMethod(Class.forName("java.util.ResourceBundle$ResourceBundleProviderHelper"), (String)"newResourceBundle", (Class[])new Class[]{Class.class});
        }
        catch (ClassNotFoundException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

