/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.target;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.Package_jdk_internal_misc;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.reflect.target.Target_java_lang_reflect_Field;
import java.lang.reflect.Field;

@TargetClass(classNameProvider=Package_jdk_internal_misc.class, className="Unsafe")
public final class Target_jdk_internal_misc_Unsafe_Reflection {
    @Substitute
    public long objectFieldOffset(Target_java_lang_reflect_Field field) {
        int offset;
        int n = offset = field.root == null ? field.offset : field.root.offset;
        if (offset > 0) {
            return offset;
        }
        throw VMError.unsupportedFeature("The offset of " + field + " is accessed without the field being first registered as unsafe accessed. Please register the field as unsafe accessed. You can do so by using a custom Feature. First, create a class that implements the org.graalvm.nativeimage.hosted.Feature interface. Then, implement the method beforeAnalysis(org.graalvm.nativeimage.BeforeAnalysisAccess config). Next, use the config object to register the field for unsafe access by calling config.registerAsUnsafeAccessed(java.lang.reflect.Field) method. Finally, specify the custom feature to the native image building tool using the -H:Features=MyCustomFeature option.");
    }

    @Substitute
    @TargetElement(onlyWith={JDK11OrLater.class})
    public long objectFieldOffset(Class<?> c, String name) {
        if (c == null || name == null) {
            throw new NullPointerException();
        }
        try {
            Field field = c.getDeclaredField(name);
            Target_java_lang_reflect_Field cast = SubstrateUtil.cast(field, Target_java_lang_reflect_Field.class);
            return this.objectFieldOffset(cast);
        }
        catch (NoSuchFieldException nse) {
            throw new InternalError();
        }
    }
}

