/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.DynamicProxySupport;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class DynamicProxyFeature
implements Feature {
    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        DynamicProxySupport dynamicProxySupport = new DynamicProxySupport(imageClassLoader.getClassLoader());
        ImageSingletons.add(DynamicProxyRegistry.class, (Object)dynamicProxySupport);
        Consumer<String[]> adapter = interfaceNames -> {
            Class[] interfaces = new Class[((String[])interfaceNames).length];
            for (int i = 0; i < ((String[])interfaceNames).length; ++i) {
                String className = interfaceNames[i];
                Class<?> clazz = imageClassLoader.findClassByName(className, false);
                if (clazz == null) {
                    throw new RuntimeException("Class " + className + " not found");
                }
                if (!clazz.isInterface()) {
                    throw new RuntimeException("The class \"" + className + "\" is not an interface.");
                }
                interfaces[i] = clazz;
            }
            dynamicProxySupport.addProxyClass(interfaces);
        };
        ProxyConfigurationParser parser = new ProxyConfigurationParser(adapter);
        ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "dynamic proxy", ConfigurationFiles.Options.DynamicProxyConfigurationFiles, ConfigurationFiles.Options.DynamicProxyConfigurationResources, "proxy-config.json");
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest proxyFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).proxyFallback;
        if (proxyFallback != null && ConfigurationFiles.Options.DynamicProxyConfigurationFiles.getValue() == null && ConfigurationFiles.Options.DynamicProxyConfigurationResources.getValue() == null) {
            throw proxyFallback;
        }
    }
}

