/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.hosted.code.CompileQueue;
import com.oracle.svm.hosted.image.LIRNativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageCodeCacheFactory;
import com.oracle.svm.hosted.image.NativeImageHeap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
class SubstrateLIRBackendFeature
implements Feature {
    SubstrateLIRBackendFeature() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return SubstrateOptions.CompilerBackend.getValue().equals("lir");
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(NativeImageCodeCacheFactory.class, (Object)new NativeImageCodeCacheFactory(){

            @Override
            public NativeImageCodeCache newCodeCache(CompileQueue compileQueue, NativeImageHeap heap, Platform targetPlatform) {
                return new LIRNativeImageCodeCache(compileQueue.getCompilations(), heap);
            }
        });
        ImageSingletons.add(SnippetRuntime.ExceptionStackFrameVisitor.class, (Object)new SnippetRuntime.ExceptionStackFrameVisitor());
    }
}

