/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.SubstrateIntrinsicGraphBuilder;
import com.oracle.graal.pointsto.util.CompletionExecutor;
import com.oracle.graal.pointsto.util.Timer;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AlwaysInlineAllCallees;
import com.oracle.svm.core.annotate.DeoptTest;
import com.oracle.svm.core.annotate.NeverInlineTrivial;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Specialize;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.deopt.DeoptEntryInfopoint;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.nodes.DeoptEntryNode;
import com.oracle.svm.core.graal.nodes.DeoptTestNode;
import com.oracle.svm.core.graal.phases.DeadStoreRemovalPhase;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.heap.RestrictHeapAccessCallees;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureHandler;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.code.CompilationInfo;
import com.oracle.svm.hosted.code.CompilationInfoSupport;
import com.oracle.svm.hosted.code.InliningUtilities;
import com.oracle.svm.hosted.code.MustNotSynchronizeAnnotationChecker;
import com.oracle.svm.hosted.code.RestrictHeapAccessAnnotationChecker;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.SubstrateHostedCompilationIdentifier;
import com.oracle.svm.hosted.code.UninterruptibleAnnotationChecker;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.phases.DevirtualizeCallsPhase;
import com.oracle.svm.hosted.phases.HostedGraphBuilderPhase;
import com.oracle.svm.hosted.phases.StrengthenStampsPhase;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ForkJoinPool;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecode;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.GraalCompiler;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.lir.RedundantMoveElimination;
import org.graalvm.compiler.lir.alloc.RegisterAllocationPhase;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.asm.CompilationResultBuilderFactory;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.PhaseSuite;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.FixReadsPhase;
import org.graalvm.compiler.phases.common.FloatingReadPhase;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.phases.tiers.HighTierContext;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.GraphOrder;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.virtual.phases.ea.EarlyReadEliminationPhase;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.nativeimage.ImageSingletons;

public class CompileQueue {
    protected final HostedUniverse universe;
    private final Boolean deoptimizeAll;
    protected CompletionExecutor executor;
    private final ConcurrentMap<HostedMethod, CompileTask> compilations;
    protected final RuntimeConfiguration runtimeConfig;
    private Suites regularSuites = null;
    private Suites deoptTargetSuites = null;
    private LIRSuites regularLIRSuites = null;
    private LIRSuites deoptTargetLIRSuites = null;
    private final ConcurrentMap<Constant, DataSection.Data> dataCache;
    private SnippetReflectionProvider snippetReflection;
    private final FeatureHandler featureHandler;
    private volatile boolean inliningProgress;

    public CompileQueue(DebugContext debug, FeatureHandler featureHandler, HostedUniverse universe, SharedRuntimeConfigurationBuilder runtimeConfigBuilder, Boolean deoptimizeAll, SnippetReflectionProvider snippetReflection, ForkJoinPool executorService) {
        this.universe = universe;
        this.compilations = new ConcurrentHashMap<HostedMethod, CompileTask>();
        this.runtimeConfig = runtimeConfigBuilder.getRuntimeConfig();
        this.deoptimizeAll = deoptimizeAll;
        this.dataCache = new ConcurrentHashMap<Constant, DataSection.Data>();
        this.executor = new CompletionExecutor(universe.getBigBang(), executorService);
        this.featureHandler = featureHandler;
        this.snippetReflection = snippetReflection;
        this.callForReplacements(debug, this.runtimeConfig);
    }

    public static OptimisticOptimizations getOptimisticOpts() {
        return OptimisticOptimizations.ALL.remove(new OptimisticOptimizations.Optimization[]{OptimisticOptimizations.Optimization.UseLoopLimitChecks});
    }

    protected void callForReplacements(DebugContext debug, RuntimeConfiguration runtimeConfig) {
        NativeImageGenerator.registerReplacements(debug, this.featureHandler, runtimeConfig, runtimeConfig.getProviders(), this.snippetReflection, true, true);
    }

    public void finish(DebugContext debug) {
        try {
            String imageName = this.universe.getBigBang().getHostVM().getImageName();
            try (Timer.StopTimer t = new Timer(imageName, "(parse)").start();){
                this.parseAll();
            }
            UninterruptibleAnnotationChecker.check(debug, this.universe.getMethods());
            RestrictHeapAccessAnnotationChecker.check(debug, this.universe, this.universe.getMethods());
            MustNotSynchronizeAnnotationChecker.check(debug, this.universe.getMethods());
            this.beforeCompileAll(debug);
            if (SubstrateOptions.AOTInline.getValue().booleanValue() && SubstrateOptions.AOTTrivialInline.getValue().booleanValue()) {
                var4_5 = null;
                try (Timer.StopTimer ignored = new Timer(imageName, "(inline)").start();){
                    this.inlineTrivialMethods(debug);
                }
                catch (Throwable throwable) {
                    var4_5 = throwable;
                    throw throwable;
                }
            }
            assert (this.suitesNotCreated());
            this.createSuites();
            t = new Timer(imageName, "(compile)").start();
            var4_5 = null;
            try {
                this.compileAll();
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (t != null) {
                    if (var4_5 != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        t.close();
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            throw new InterruptImageBuilding();
        }
        if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
            this.printMethodHistogram();
        }
    }

    private boolean suitesNotCreated() {
        return this.regularSuites == null && this.deoptTargetLIRSuites == null && this.regularLIRSuites == null && this.deoptTargetSuites == null;
    }

    private void createSuites() {
        this.regularSuites = NativeImageGenerator.createSuites(this.featureHandler, this.runtimeConfig, this.snippetReflection, true, !this.universe.isPostParseCanonicalized());
        this.deoptTargetSuites = NativeImageGenerator.createSuites(this.featureHandler, this.runtimeConfig, this.snippetReflection, true, !this.universe.isPostParseCanonicalized());
        this.removeDeoptTargetOptimizations(this.deoptTargetSuites);
        this.regularLIRSuites = NativeImageGenerator.createLIRSuites(this.featureHandler, this.runtimeConfig.getProviders(), true);
        this.deoptTargetLIRSuites = NativeImageGenerator.createLIRSuites(this.featureHandler, this.runtimeConfig.getProviders(), true);
        CompileQueue.removeDeoptTargetOptimizations(this.deoptTargetLIRSuites);
    }

    public static PhaseSuite<HighTierContext> afterParseCanonicalization() {
        PhaseSuite phaseSuite = new PhaseSuite();
        phaseSuite.appendPhase((BasePhase)new DeadStoreRemovalPhase());
        phaseSuite.appendPhase((BasePhase)new DevirtualizeCallsPhase());
        phaseSuite.appendPhase((BasePhase)new CanonicalizerPhase());
        phaseSuite.appendPhase((BasePhase)new StrengthenStampsPhase());
        phaseSuite.appendPhase((BasePhase)new CanonicalizerPhase());
        return phaseSuite;
    }

    private void printMethodHistogram() {
        long sizeAllMethods = 0L;
        long sizeDeoptMethods = 0L;
        long sizeDeoptMethodsInNonDeopt = 0L;
        long sizeNonDeoptMethods = 0L;
        int numberOfMethods = 0;
        int numberOfNonDeopt = 0;
        int numberOfDeopt = 0;
        long totalNumDeoptEntryPoints = 0L;
        long totalNumDuringCallEntryPoints = 0L;
        System.out.format("Code Size; Nodes Before; Nodes After; Is Trivial; Deopt Target; Code Size; Nodes Before; Nodes After; Deopt Entries; Deopt During Call; Entry Points; Direct Calls; Virtual Calls; Method\n", new Object[0]);
        ArrayList tasks = new ArrayList(this.compilations.values());
        tasks.sort(Comparator.comparing(t2 -> t2.method.format("%H.%n(%p) %r")));
        for (CompileTask task : tasks) {
            HostedMethod method = task.method;
            CompilationResult result = task.result;
            CompilationInfo ci = method.compilationInfo;
            if (ci.isDeoptTarget()) continue;
            ++numberOfMethods;
            sizeAllMethods += (long)result.getTargetCodeSize();
            System.out.format("%8d; %5d; %5d; %s;", result.getTargetCodeSize(), ci.numNodesBeforeCompilation, ci.numNodesAfterCompilation, ci.isTrivialMethod ? "T" : " ");
            int deoptMethodSize = 0;
            if (ci.deoptTarget != null) {
                CompilationInfo dci = ci.deoptTarget.compilationInfo;
                ++numberOfDeopt;
                deoptMethodSize = ((CompileTask)this.compilations.get((Object)ci.deoptTarget)).result.getTargetCodeSize();
                sizeDeoptMethods += (long)deoptMethodSize;
                sizeDeoptMethodsInNonDeopt += (long)result.getTargetCodeSize();
                totalNumDeoptEntryPoints += dci.numDeoptEntryPoints;
                totalNumDuringCallEntryPoints += dci.numDuringCallEntryPoints;
                System.out.format(" D; %6d; %5d; %5d; %4d; %4d;", deoptMethodSize, dci.numNodesBeforeCompilation, dci.numNodesAfterCompilation, dci.numDeoptEntryPoints, dci.numDuringCallEntryPoints);
            } else {
                sizeNonDeoptMethods += (long)result.getTargetCodeSize();
                ++numberOfNonDeopt;
                System.out.format("  ; %6d; %5d; %5d; %4d; %4d;", 0, 0, 0, 0, 0);
            }
            System.out.format(" %4d; %4d; %4d; %s\n", task.allReasons.stream().filter(t -> t instanceof EntryPointReason).count(), task.allReasons.stream().filter(t -> t instanceof DirectCallReason).count(), task.allReasons.stream().filter(t -> t instanceof VirtualCallReason).count(), method.format("%H.%n(%p) %r"));
        }
        System.out.println();
        System.out.println("Size all methods                           ; " + sizeAllMethods);
        System.out.println("Size deopt methods                         ; " + sizeDeoptMethods);
        System.out.println("Size deopt methods in non-deopt mode       ; " + sizeDeoptMethodsInNonDeopt);
        System.out.println("Size non-deopt method                      ; " + sizeNonDeoptMethods);
        System.out.println("Number of methods                          ; " + numberOfMethods);
        System.out.println("Number of non-deopt methods                ; " + numberOfNonDeopt);
        System.out.println("Number of deopt methods                    ; " + numberOfDeopt);
        System.out.println("Number of deopt entry points               ; " + totalNumDeoptEntryPoints);
        System.out.println("Number of deopt during calls entries       ; " + totalNumDuringCallEntryPoints);
    }

    private void parseAll() throws InterruptedException {
        this.executor.init();
        this.parseDeoptimizationTargetMethods();
        this.parseAheadOfTimeCompiledMethods();
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
    }

    private void parseAheadOfTimeCompiledMethods() {
        this.universe.getMethods().stream().filter(method -> method.isEntryPoint() || CompilationInfoSupport.singleton().isForcedCompilation((ResolvedJavaMethod)method)).forEach(method -> this.ensureParsed((HostedMethod)method, new EntryPointReason()));
        SubstrateForeignCallsProvider foreignCallsProvider = (SubstrateForeignCallsProvider)this.runtimeConfig.getProviders().getForeignCalls();
        foreignCallsProvider.getForeignCalls().keySet().stream().map(descriptor -> (HostedMethod)descriptor.findMethod(this.runtimeConfig.getProviders().getMetaAccess())).filter(method -> method.wrapped.isRootMethod()).forEach(method -> this.ensureParsed((HostedMethod)method, new EntryPointReason()));
    }

    private void parseDeoptimizationTargetMethods() {
        this.universe.getMethods().stream().filter(method -> CompilationInfoSupport.singleton().isDeoptTarget((ResolvedJavaMethod)method)).forEach(method -> this.ensureParsed(this.universe.createDeoptTarget((HostedMethod)method), new EntryPointReason()));
        this.universe.getMethods().stream().filter(method -> method.getWrapped().isImplementationInvoked() && this.canDeoptForTesting((HostedMethod)method)).forEach(this::ensureParsedForDeoptTesting);
    }

    private void ensureParsedForDeoptTesting(HostedMethod method) {
        method.compilationInfo.canDeoptForTesting = true;
        this.ensureParsed(this.universe.createDeoptTarget(method), new EntryPointReason());
    }

    protected void beforeCompileAll(DebugContext debug) throws InterruptedException {
    }

    private void checkTrivial(HostedMethod method) {
        if (!method.compilationInfo.isTrivialMethod() && method.canBeInlined() && InliningUtilities.isTrivialMethod(method.compilationInfo.getGraph())) {
            method.compilationInfo.setTrivialMethod(true);
            this.inliningProgress = true;
        }
    }

    private void inlineTrivialMethods(DebugContext debug) throws InterruptedException {
        this.executor.init();
        PhaseSuite<HighTierContext> afterParseSuite = CompileQueue.afterParseCanonicalization();
        for (HostedMethod method2 : this.universe.getMethods()) {
            try {
                DebugContext.Scope s = debug.scope((Object)"InlineTrivial", (Object)method2.compilationInfo.getGraph(), (Object)method2, (Object)this);
                Throwable throwable = null;
                try {
                    if (method2.compilationInfo.getGraph() == null) continue;
                    HostedProviders providers = (HostedProviders)this.runtimeConfig.lookupBackend(method2).getProviders();
                    if (!this.universe.isPostParseCanonicalized()) {
                        this.executor.execute(newDebug -> {
                            method.compilationInfo.getGraph().resetDebug(newDebug);
                            afterParseSuite.apply(method.compilationInfo.getGraph(), (Object)new HighTierContext((Providers)providers, afterParseSuite, CompileQueue.getOptimisticOpts()));
                            assert (GraphOrder.assertSchedulableGraph((StructuredGraph)method.compilationInfo.getGraph()));
                        });
                    }
                    this.checkTrivial(method2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (s == null) continue;
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    s.close();
                }
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
        }
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
        this.universe.setPostParseCanonicalized();
        int round = 0;
        do {
            this.inliningProgress = false;
            try (Indent ignored = debug.logAndIndent("==== Trivial Inlining  round %d\n", ++round);){
                this.executor.init();
                this.universe.getMethods().stream().filter(method -> method.compilationInfo.getGraph() != null).forEach(method -> this.executor.execute((CompletionExecutor.DebugContextRunnable)new TrivialInlineTask((HostedMethod)method)));
                this.universe.getMethods().stream().map(method -> method.compilationInfo.getDeoptTargetMethod()).filter(Objects::nonNull).forEach(deoptTargetMethod -> this.executor.execute((CompletionExecutor.DebugContextRunnable)new TrivialInlineTask((HostedMethod)deoptTargetMethod)));
                this.executor.start();
                this.executor.complete();
                this.executor.shutdown();
            }
        } while (this.inliningProgress);
    }

    private void doInlineTrivial(DebugContext debug, HostedMethod method) {
        StructuredGraph graph = (StructuredGraph)method.compilationInfo.getGraph().copy(debug);
        try (DebugContext.Scope s = debug.scope((Object)"InlineTrivial", (Object)graph, (Object)method, (Object)this);){
            try (Indent in = debug.logAndIndent("do inline trivial in %s", (Object)method);){
                boolean inlined = false;
                for (Invoke invoke : graph.getInvokes()) {
                    if (invoke instanceof InvokeNode) {
                        throw VMError.shouldNotReachHere("Found InvokeNode without exception edge: invocation of " + invoke.callTarget().targetMethod().format("%H.%n(%p)") + " in " + (graph.method() == null ? graph.toString() : graph.method().format("%H.%n(%p)")));
                    }
                    if (!invoke.useForInlining()) continue;
                    inlined |= CompileQueue.tryInlineTrivial(graph, invoke, !inlined);
                }
                if (inlined) {
                    Providers providers = this.runtimeConfig.lookupBackend(method).getProviders();
                    new CanonicalizerPhase().apply(graph, (Object)providers);
                    method.compilationInfo.setGraph(graph);
                    this.checkTrivial(method);
                    this.inliningProgress = true;
                }
            }
            catch (Throwable ex) {
                GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                error.addContext("method: " + method.format("%r %H.%n(%p)"));
                throw error;
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static boolean tryInlineTrivial(StructuredGraph graph, Invoke invoke, boolean firstInline) {
        HostedMethod singleCallee;
        if (invoke.getInvokeKind().isDirect() && CompileQueue.makeInlineDecision(invoke, singleCallee = (HostedMethod)invoke.callTarget().targetMethod()) && InliningUtilities.recursionDepth(invoke, singleCallee) == 0) {
            if (firstInline) {
                graph.getDebug().dump(4, (Object)graph, "Before inlining");
            }
            InliningUtil.inline((Invoke)invoke, (StructuredGraph)singleCallee.compilationInfo.getGraph(), (boolean)true, (ResolvedJavaMethod)singleCallee);
            graph.getDebug().dump(4, (Object)graph, "After inlining %s with trivial callee %s", (Object)invoke, (Object)singleCallee.getQualifiedName());
            return true;
        }
        return false;
    }

    private static boolean makeInlineDecision(Invoke invoke, HostedMethod callee) {
        if (!callee.canBeInlined() || callee.getAnnotation(NeverInlineTrivial.class) != null) {
            return false;
        }
        if (callee.shouldBeInlined() || CompileQueue.callerAnnotatedWith(invoke, AlwaysInlineAllCallees.class)) {
            return true;
        }
        return callee.compilationInfo.isTrivialMethod();
    }

    private static boolean mustNotAllocateCallee(HostedMethod method) {
        return ((RestrictHeapAccessCallees)ImageSingletons.lookup(RestrictHeapAccessCallees.class)).mustNotAllocate(method);
    }

    private static boolean mustNotAllocate(HostedMethod method) {
        RestrictHeapAccess annotation = method.getAnnotation(RestrictHeapAccess.class);
        return annotation != null && annotation.access() == RestrictHeapAccess.Access.NO_ALLOCATION && !annotation.mayBeInlined();
    }

    public static boolean callerAnnotatedWith(Invoke invoke, Class<? extends Annotation> annotationClass) {
        for (FrameState state = invoke.stateAfter(); state != null; state = state.outerFrameState()) {
            if (state.getMethod().getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }

    protected void compileAll() throws InterruptedException {
        this.executor.init();
        this.universe.getMethods().stream().filter(method -> method.isEntryPoint() || CompilationInfoSupport.singleton().isForcedCompilation((ResolvedJavaMethod)method)).forEach(method -> this.ensureCompiled((HostedMethod)method, new EntryPointReason()));
        this.universe.getMethods().stream().map(method -> method.compilationInfo.getDeoptTargetMethod()).filter(deoptTargetMethod -> deoptTargetMethod != null).forEach(deoptTargetMethod -> this.ensureCompiled((HostedMethod)deoptTargetMethod, new EntryPointReason()));
        this.executor.start();
        this.executor.complete();
        this.executor.shutdown();
    }

    protected void ensureParsed(HostedMethod method, CompileReason reason) {
        if (!method.compilationInfo.inParseQueue.getAndSet(true)) {
            this.executor.execute((CompletionExecutor.DebugContextRunnable)new ParseTask(method, reason));
        }
    }

    protected void doParse(DebugContext debug, ParseTask task) {
        ParseFunction fun = ((ParseTask)task).method.compilationInfo.getCustomParseFunction();
        if (fun == null) {
            fun = this::defaultParseFunction;
        }
        fun.parse(debug, task.method, task.reason, this.runtimeConfig);
    }

    private void defaultParseFunction(DebugContext debug, HostedMethod method, CompileReason reason, RuntimeConfiguration config) {
        InvocationPlugin plugin;
        if (!NativeImageOptions.AllowFoldMethods.getValue().booleanValue() && method.getAnnotation(Fold.class) != null || method.getAnnotation(Node.NodeIntrinsic.class) != null) {
            throw VMError.shouldNotReachHere("Parsing method annotated with @Fold or @NodeIntrinsic: " + method.format("%H.%n(%p)"));
        }
        HostedProviders providers = (HostedProviders)config.lookupBackend(method).getProviders();
        boolean needParsing = false;
        StructuredGraph graph = method.buildGraph(debug, method, providers, GraphProvider.Purpose.AOT_COMPILATION);
        if (graph == null && (plugin = providers.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation((ResolvedJavaMethod)method)) != null && !plugin.inlineOnly()) {
            ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode((ResolvedJavaMethod)method);
            graph = new SubstrateIntrinsicGraphBuilder(debug.getOptions(), debug, (CoreProviders)providers, (Bytecode)code).buildGraph(plugin);
        }
        if (graph == null && method.isNative() && NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            graph = DeletedMethod.buildGraph(debug, method, providers, DeletedMethod.NATIVE_MESSAGE);
        }
        if (graph == null) {
            needParsing = true;
            graph = new StructuredGraph.Builder(debug.getOptions(), debug).method((ResolvedJavaMethod)method).build();
        }
        try (DebugContext.Scope s = debug.scope((Object)"Parsing", (Object)graph, (Object)method, (Object)this);){
            try {
                if (needParsing) {
                    GraphBuilderConfiguration gbConf = this.createHostedGraphBuilderConfiguration(providers, method);
                    new HostedGraphBuilderPhase((Providers)providers, gbConf, CompileQueue.getOptimisticOpts(), null, providers.getWordTypes()).apply(graph);
                } else {
                    graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
                }
                method.compilationInfo.graph = graph;
                for (Invoke invoke : graph.getInvokes()) {
                    if (!this.canBeUsedForInlining(invoke)) {
                        invoke.setUseForInlining(false);
                    }
                    CallTargetNode targetNode = invoke.callTarget();
                    HostedMethod invokeTarget = (HostedMethod)targetNode.targetMethod();
                    if (targetNode.invokeKind().isIndirect() || targetNode instanceof IndirectCallTargetNode) {
                        for (HostedMethod invokeImplementation : invokeTarget.getImplementations()) {
                            CompileQueue.handleSpecialization(method, targetNode, invokeTarget, invokeImplementation);
                            this.ensureParsed(invokeImplementation, new VirtualCallReason(method, invokeImplementation, reason));
                        }
                        continue;
                    }
                    if (!invokeTarget.wrapped.isImplementationInvoked()) continue;
                    CompileQueue.handleSpecialization(method, targetNode, invokeTarget, invokeTarget);
                    this.ensureParsed(invokeTarget, new DirectCallReason(method, reason));
                }
            }
            catch (Throwable ex) {
                GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
                error.addContext("method: " + method.format("%r %H.%n(%p)"));
                throw error;
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    protected GraphBuilderConfiguration createHostedGraphBuilderConfiguration(HostedProviders providers, HostedMethod method) {
        GraphBuilderConfiguration gbConf = GraphBuilderConfiguration.getDefault((GraphBuilderConfiguration.Plugins)providers.getGraphBuilderPlugins()).withBytecodeExceptionMode(GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll);
        if (SubstrateOptions.Optimize.getValue() <= 0 && !method.isDeoptTarget()) {
            gbConf = gbConf.withRetainLocalVariables(true);
        }
        return gbConf;
    }

    protected boolean canBeUsedForInlining(Invoke invoke) {
        HostedMethod caller = (HostedMethod)invoke.asNode().graph().method();
        HostedMethod callee = (HostedMethod)invoke.callTarget().targetMethod();
        if (this.canDeoptForTesting(caller) && Modifier.isNative(callee.getModifiers())) {
            return false;
        }
        if (this.canDeoptForTesting(caller) && this.universe.getMethodsWithStackValues().contains(callee.wrapped)) {
            return false;
        }
        if (caller.compilationInfo.isDeoptTarget()) {
            if (caller.compilationInfo.isDeoptEntry(invoke.bci(), true, false)) {
                return false;
            }
            if (CompilationInfoSupport.singleton().isDeoptInliningExclude(callee)) {
                return false;
            }
        }
        if (callee.getAnnotation(Specialize.class) != null) {
            return false;
        }
        if (CompileQueue.callerAnnotatedWith(invoke, Specialize.class) && callee.getAnnotation(DeoptTest.class) != null) {
            return false;
        }
        Uninterruptible calleeUninterruptible = callee.getAnnotation(Uninterruptible.class);
        if (calleeUninterruptible != null && !calleeUninterruptible.mayBeInlined() && caller.getAnnotation(Uninterruptible.class) == null) {
            return false;
        }
        if (!CompileQueue.mustNotAllocateCallee(caller) && CompileQueue.mustNotAllocate(callee)) {
            return false;
        }
        if (!callee.canBeInlined()) {
            return false;
        }
        return invoke.useForInlining();
    }

    private static void handleSpecialization(HostedMethod method, CallTargetNode targetNode, HostedMethod invokeTarget, HostedMethod invokeImplementation) {
        if (method.getAnnotation(Specialize.class) != null && !method.compilationInfo.isDeoptTarget() && invokeTarget.getAnnotation(DeoptTest.class) != null) {
            if (invokeImplementation.compilationInfo.specializedArguments != null) {
                VMError.shouldNotReachHere("Specialized method " + invokeImplementation.format("%H.%n(%p)") + " can only be called from one place");
            }
            invokeImplementation.compilationInfo.specializedArguments = new ConstantNode[targetNode.arguments().size()];
            int idx = 0;
            for (ValueNode argument : targetNode.arguments()) {
                if (!(argument instanceof ConstantNode)) {
                    VMError.shouldNotReachHere("Argument " + idx + " of specialized method " + invokeImplementation.format("%H.%n(%p)") + " is not constant");
                }
                invokeImplementation.compilationInfo.specializedArguments[idx++] = (ConstantNode)argument;
            }
        }
    }

    protected void ensureCompiled(HostedMethod method, CompileReason reason) {
        CompileTask task = new CompileTask(method, reason);
        CompileTask oldTask = this.compilations.putIfAbsent(method, task);
        if (oldTask != null) {
            if (oldTask.allReasons != null) {
                oldTask.allReasons.add(reason);
            }
            return;
        }
        if (method.compilationInfo.specializedArguments != null) {
            StructuredGraph graph = method.compilationInfo.graph;
            assert (GraphOrder.assertSchedulableGraph((StructuredGraph)graph));
            int idx = 0;
            for (ConstantNode argument : method.compilationInfo.specializedArguments) {
                ParameterNode local;
                if ((local = graph.getParameter(idx++)) == null) continue;
                local.replaceAndDelete((Node)ConstantNode.forConstant((JavaConstant)argument.asJavaConstant(), (MetaAccessProvider)this.runtimeConfig.getProviders().getMetaAccess(), (StructuredGraph)graph));
            }
        }
        this.executor.execute((CompletionExecutor.DebugContextRunnable)task);
        method.setCompiled();
    }

    protected CompilationResult doCompile(DebugContext debug, HostedMethod method, CompilationIdentifier compilationIdentifier, CompileReason reason) {
        CompileFunction fun = method.compilationInfo.getCustomCompileFunction();
        if (fun == null) {
            fun = this::defaultCompileFunction;
        }
        return fun.compile(debug, method, compilationIdentifier, reason, this.runtimeConfig);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompilationResult defaultCompileFunction(DebugContext debug, HostedMethod method, CompilationIdentifier compilationIdentifier, CompileReason reason, RuntimeConfiguration config) {
        if (NativeImageOptions.PrintAOTCompilation.getValue().booleanValue()) {
            System.out.println("Compiling " + method.format("%r %H.%n(%p)") + "  [" + reason + "]");
        }
        SubstrateBackend backend = config.lookupBackend(method);
        StructuredGraph graph = method.compilationInfo.graph;
        assert (graph != null) : method;
        graph = graph.copyWithIdentifier(compilationIdentifier, debug);
        assert (GraphOrder.assertSchedulableGraph((StructuredGraph)graph));
        try (DebugContext.Scope s = debug.scope((Object)"Compiling", (Object)graph, (Object)method, (Object)this);){
            if (this.deoptimizeAll.booleanValue() && method.compilationInfo.canDeoptForTesting) {
                CompileQueue.insertDeoptTests(method, graph);
            }
            method.compilationInfo.numNodesBeforeCompilation = graph.getNodeCount();
            method.compilationInfo.numDeoptEntryPoints = graph.getNodes().filter(DeoptEntryNode.class).count();
            method.compilationInfo.numDuringCallEntryPoints = graph.getNodes(MethodCallTargetNode.TYPE).snapshot().stream().map(CallTargetNode::invoke).filter(invoke -> method.compilationInfo.isDeoptEntry(invoke.bci(), true, false)).count();
            Suites suites = method.compilationInfo.isDeoptTarget() ? this.deoptTargetSuites : this.regularSuites;
            LIRSuites lirSuites = method.compilationInfo.isDeoptTarget() ? this.deoptTargetLIRSuites : this.regularLIRSuites;
            CompilationResult result = backend.newCompilationResult(compilationIdentifier, method.format("%H.%n(%p)"));
            try (Indent indent = debug.logAndIndent("compile %s", (Object)method);){
                GraalCompiler.compileGraph((StructuredGraph)graph, (ResolvedJavaMethod)method, (Providers)backend.getProviders(), (Backend)backend, null, (OptimisticOptimizations)CompileQueue.getOptimisticOpts(), (ProfilingInfo)method.getProfilingInfo(), (Suites)suites, (LIRSuites)lirSuites, (CompilationResult)result, (CompilationResultBuilderFactory)new HostedCompilationResultBuilderFactory(), (boolean)false);
            }
            method.getProfilingInfo().setCompilerIRSize(StructuredGraph.class, method.compilationInfo.graph.getNodeCount());
            method.compilationInfo.numNodesAfterCompilation = graph.getNodeCount();
            if (method.compilationInfo.isDeoptTarget()) assert (CompileQueue.verifyDeoptTarget(method, result));
            for (Infopoint infopoint : result.getInfopoints()) {
                if (!(infopoint instanceof Call)) continue;
                Call call = (Call)infopoint;
                HostedMethod callTarget = (HostedMethod)call.target;
                if (call.direct) {
                    this.ensureCompiled(callTarget, new DirectCallReason(method, reason));
                    continue;
                }
                if (callTarget == null || callTarget.getImplementations() == null) continue;
                for (HostedMethod impl : callTarget.getImplementations()) {
                    this.ensureCompiled(impl, new VirtualCallReason(method, callTarget, reason));
                }
            }
            if (result.getTargetCode().length > result.getTargetCodeSize()) {
                result.setTargetCode(Arrays.copyOf(result.getTargetCode(), result.getTargetCodeSize()), result.getTargetCodeSize());
            }
            CompilationResult compilationResult = result;
            return compilationResult;
        }
        catch (Throwable ex) {
            GraalError error = ex instanceof GraalError ? (GraalError)ex : new GraalError(ex);
            error.addContext("method: " + method.format("%r %H.%n(%p)") + "  [" + reason + "]");
            throw error;
        }
    }

    protected void removeDeoptTargetOptimizations(Suites suites) {
        GraalConfiguration.instance().removeDeoptTargetOptimizations(suites);
        PhaseSuite highTier = suites.getHighTier();
        VMError.guarantee(highTier.removePhase(PartialEscapePhase.class));
        VMError.guarantee(highTier.removePhase(EarlyReadEliminationPhase.class));
        PhaseSuite midTier = suites.getMidTier();
        VMError.guarantee(midTier.removePhase(FloatingReadPhase.class));
        PhaseSuite lowTier = suites.getLowTier();
        ((FixReadsPhase)lowTier.findPhase(FixReadsPhase.class).previous()).setReplaceInputsWithConstants(false);
    }

    private static void removeDeoptTargetOptimizations(LIRSuites lirSuites) {
        lirSuites.getPostAllocationOptimizationStage().findPhase(RedundantMoveElimination.class).remove();
        ((RegisterAllocationPhase)lirSuites.getAllocationStage().findPhaseInstance(RegisterAllocationPhase.class)).setNeverSpillConstants(true);
    }

    private static boolean verifyDeoptTarget(HostedMethod method, CompilationResult result) {
        HashMap<Long, BytecodeFrame> encodedBciMap = new HashMap<Long, BytecodeFrame>();
        assert (method.compilationInfo.graph != null) : "Deopt target must have a graph.";
        assert (method.compilationInfo.graph.getNodes(StackValueNode.TYPE).isEmpty()) : "No stack value nodes must be present in deopt target.";
        for (Infopoint infopoint : result.getInfopoints()) {
            long encodedBci;
            BytecodeFrame topFrame;
            DebugInfo debugInfo;
            if (infopoint.debugInfo == null || !(debugInfo = infopoint.debugInfo).hasFrame()) continue;
            BytecodeFrame rootFrame = topFrame = debugInfo.frame();
            while (rootFrame.caller() != null) {
                rootFrame = rootFrame.caller();
            }
            assert (rootFrame.getMethod().equals(method));
            boolean isDeoptEntry = method.compilationInfo.isDeoptEntry(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException);
            if (infopoint instanceof DeoptEntryInfopoint) {
                assert (isDeoptEntry);
            } else {
                if (!rootFrame.duringCall || !isDeoptEntry) continue;
                assert (infopoint instanceof Call || CompileQueue.isSingleSteppingInfopoint(infopoint));
            }
            if (encodedBciMap.containsKey(encodedBci = FrameInfoEncoder.encodeBci(rootFrame.getBCI(), rootFrame.duringCall, rootFrame.rethrowException))) assert (((BytecodeFrame)encodedBciMap.get(encodedBci)).equals((Object)rootFrame)) : "duplicate encoded bci " + encodedBci + " in deopt target " + method + " with different debug info:\n\n" + rootFrame + "\n\n" + encodedBciMap.get(encodedBci);
            encodedBciMap.put(encodedBci, rootFrame);
        }
        return true;
    }

    private static boolean isSingleSteppingInfopoint(Infopoint infopoint) {
        return infopoint.reason == InfopointReason.METHOD_START || infopoint.reason == InfopointReason.METHOD_END || infopoint.reason == InfopointReason.BYTECODE_POSITION;
    }

    protected boolean canDeoptForTesting(HostedMethod method) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        if (method.getAnnotation(DeoptTest.class) != null) {
            return true;
        }
        if (method.isEntryPoint()) {
            return false;
        }
        if (method.isNative()) {
            return false;
        }
        if (method.wrapped.isIntrinsicMethod()) {
            return false;
        }
        if (method.getAnnotation(Uninterruptible.class) != null) {
            return false;
        }
        if (method.getAnnotation(RestrictHeapAccess.class) != null) {
            return false;
        }
        if (this.universe.getMethodsWithStackValues().contains(method.wrapped)) {
            return false;
        }
        if (this.deoptimizeAll.booleanValue()) {
            String className = method.getDeclaringClass().getName();
            if (className.contains("/svm/core/code/CodeInfoEncoder") || className.contains("com/oracle/svm/core/thread/JavaThreads") || className.contains("com/oracle/svm/core/heap/") || className.contains("com/oracle/svm/core/genscavenge/") || className.contains("debug/internal/DebugValueMap") && method.getName().equals("registerTopLevel")) {
                return false;
            }
            return method.getCode() != null;
        }
        return false;
    }

    private static void insertDeoptTests(HostedMethod method, StructuredGraph graph) {
        for (Node node : graph.getNodes()) {
            if (!(node instanceof FixedWithNextNode) || !(node instanceof StateSplit) || node instanceof InvokeNode || node instanceof ForeignCallNode || node instanceof DeoptTestNode || method.isSynchronized() && node instanceof StartNode) continue;
            FixedWithNextNode fixedWithNext = (FixedWithNextNode)node;
            FixedNode next = fixedWithNext.next();
            DeoptTestNode testNode = (DeoptTestNode)graph.add((Node)new DeoptTestNode());
            fixedWithNext.setNext(null);
            testNode.setNext(next);
            fixedWithNext.setNext((FixedNode)testNode);
        }
    }

    public Map<HostedMethod, CompilationResult> getCompilations() {
        TreeMap<HostedMethod, CompilationResult> result = new TreeMap<HostedMethod, CompilationResult>();
        for (Map.Entry entry : this.compilations.entrySet()) {
            result.put((HostedMethod)entry.getKey(), ((CompileTask)entry.getValue()).result);
        }
        return result;
    }

    class HostedCompilationResultBuilderFactory
    implements CompilationResultBuilderFactory {
        HostedCompilationResultBuilderFactory() {
        }

        public CompilationResultBuilder createBuilder(CodeCacheProvider codeCache, ForeignCallsProvider foreignCalls, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register nullRegister) {
            return new CompilationResultBuilder(codeCache, foreignCalls, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, nullRegister, EconomicMap.wrapMap((Map)CompileQueue.this.dataCache));
        }
    }

    public class ParseTask
    implements CompletionExecutor.DebugContextRunnable {
        protected final CompileReason reason;
        private final HostedMethod method;
        private final DebugContext.Description description;

        public ParseTask(HostedMethod method, CompileReason reason) {
            this.method = method;
            this.reason = reason;
            this.description = new DebugContext.Description((Object)method, method.getName());
        }

        public void run(DebugContext debug) {
            CompileQueue.this.doParse(debug, this);
        }

        public DebugContext.Description getDescription() {
            return this.description;
        }
    }

    protected class TrivialInlineTask
    implements CompletionExecutor.DebugContextRunnable {
        private final HostedMethod method;
        private final DebugContext.Description description;

        TrivialInlineTask(HostedMethod method) {
            this.method = method;
            this.description = new DebugContext.Description((Object)method, method.getName());
        }

        public void run(DebugContext debug) {
            CompileQueue.this.doInlineTrivial(debug, this.method);
        }

        public DebugContext.Description getDescription() {
            return this.description;
        }
    }

    public class CompileTask
    implements CompletionExecutor.DebugContextRunnable {
        public final HostedMethod method;
        protected final CompileReason reason;
        protected final List<CompileReason> allReasons;
        public CompilationResult result;
        public final CompilationIdentifier compilationIdentifier;

        public CompileTask(HostedMethod method, CompileReason reason) {
            this.method = method;
            this.reason = reason;
            if (NativeImageOptions.PrintMethodHistogram.getValue().booleanValue()) {
                this.allReasons = Collections.synchronizedList(new ArrayList());
                this.allReasons.add(reason);
            } else {
                this.allReasons = null;
            }
            this.compilationIdentifier = new SubstrateHostedCompilationIdentifier(method);
        }

        public void run(DebugContext debug) {
            if (this.method.compilationInfo.graph != null) {
                this.method.compilationInfo.graph.resetDebug(debug);
            }
            this.result = CompileQueue.this.doCompile(debug, this.method, this.compilationIdentifier, this.reason);
        }

        public DebugContext.Description getDescription() {
            return new DebugContext.Description((Object)this.method, this.compilationIdentifier.toString(CompilationIdentifier.Verbosity.ID));
        }
    }

    public static class VirtualCallReason
    extends CompileReason {
        private final HostedMethod caller;
        private final HostedMethod callTarget;

        public VirtualCallReason(HostedMethod caller, HostedMethod callTarget, CompileReason prevReason) {
            super(prevReason);
            this.caller = caller;
            this.callTarget = callTarget;
        }

        public String toString() {
            return "Virtual call from " + this.caller.format("%r %h.%n(%p)") + ", callTarget " + this.callTarget.format("%r %h.%n(%p)");
        }
    }

    public static class DirectCallReason
    extends CompileReason {
        private final HostedMethod caller;

        public DirectCallReason(HostedMethod caller, CompileReason prevReason) {
            super(prevReason);
            this.caller = caller;
        }

        public String toString() {
            return "Direct call from " + this.caller.format("%r %h.%n(%p)");
        }
    }

    public static class EntryPointReason
    extends CompileReason {
        public EntryPointReason() {
            super(null);
        }

        public String toString() {
            return "entry point";
        }
    }

    public static abstract class CompileReason {
        private final CompileReason prevReason;

        public CompileReason(CompileReason prevReason) {
            this.prevReason = prevReason;
        }
    }

    public static interface CompileFunction {
        public CompilationResult compile(DebugContext var1, HostedMethod var2, CompilationIdentifier var3, CompileReason var4, RuntimeConfiguration var5);
    }

    public static interface ParseFunction {
        public void parse(DebugContext var1, HostedMethod var2, CompileReason var3, RuntimeConfiguration var4);
    }
}

