/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationConfiguration;
import com.oracle.svm.hosted.classinitialization.ClassInitializationFeature;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.InitKind;
import com.oracle.svm.hosted.meta.HostedType;
import com.sun.crypto.provider.SunJCE;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public class ConfigurableClassInitialization
implements ClassInitializationSupport {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private final ClassInitializationConfiguration classInitializationConfiguration = new ClassInitializationConfiguration();
    private final Map<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    private final ImageClassLoader loader;
    private UnsupportedFeatures unsupportedFeatures;
    protected MetaAccessProvider metaAccess;

    public ConfigurableClassInitialization(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        this.metaAccess = metaAccess;
        this.loader = loader;
    }

    @Override
    public void setUnsupportedFeatures(UnsupportedFeatures unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    @Override
    public InitKind specifiedInitKindFor(Class<?> clazz) {
        return this.classInitializationConfiguration.lookupKind(clazz.getTypeName());
    }

    @Override
    public Set<Class<?>> classesWithKind(InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        return this.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.toAnalysisType(type).getJavaClass()) != InitKind.BUILD_TIME;
    }

    @Override
    public boolean shouldInitializeAtRuntime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) != InitKind.BUILD_TIME;
    }

    @Override
    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.toAnalysisType(type).getJavaClass());
    }

    private InitKind ensureClassInitialized(Class<?> clazz, boolean allowErrors) {
        try {
            UNSAFE.ensureClassInitialized(clazz);
            return InitKind.BUILD_TIME;
        }
        catch (NoClassDefFoundError ex) {
            if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                if (!allowErrors) {
                    System.out.println("Warning: class initialization of class " + clazz.getTypeName() + " failed with exception " + ex.getClass().getTypeName() + (ex.getMessage() == null ? "" : ": " + ex.getMessage()) + ". This class will be initialized at run time because option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " is used for image building. " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz));
                }
                return InitKind.RUN_TIME;
            }
            return this.reportInitializationError(allowErrors, clazz, ex);
        }
        catch (Throwable t) {
            return this.reportInitializationError(allowErrors, clazz, t);
        }
    }

    private InitKind reportInitializationError(boolean allowErrors, Class<?> clazz, Throwable t) {
        if (allowErrors) {
            return InitKind.RUN_TIME;
        }
        String msg = "Class initialization of " + clazz.getTypeName() + " failed. " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz);
        if (this.unsupportedFeatures != null) {
            this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, t);
            return InitKind.RUN_TIME;
        }
        throw UserError.abort(msg, t);
    }

    private static String instructionsToInitializeAtRuntime(Class<?> clazz) {
        return "Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, clazz.getTypeName(), "initialize-at-run-time") + " to explicitly request delayed initialization of this class.";
    }

    private static AnalysisType toAnalysisType(ResolvedJavaType type) {
        return type instanceof HostedType ? ((HostedType)type).getWrapped() : (AnalysisType)type;
    }

    public void initializeAtRunTime(String name, String reason) {
        this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason);
        Class<?> clazz = this.loader.findClassByName(name, false);
        if (clazz != null) {
            this.initializeAtRunTime(clazz, reason);
        }
    }

    public void initializeAtBuildTime(String name, String reason) {
        this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason);
        Class<?> clazz = this.loader.findClassByName(name, false);
        if (clazz != null) {
            this.initializeAtBuildTime(clazz, reason);
        }
    }

    public void rerunInitialization(String name, String reason) {
        this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason);
        Class<?> clazz = this.loader.findClassByName(name, false);
        if (clazz != null) {
            this.rerunInitialization(clazz, reason);
        }
    }

    public void initializeAtRunTime(Class<?> clazz, String reason) {
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RUN_TIME, reason);
        this.setKindForSubclasses(clazz, InitKind.RUN_TIME);
        ConfigurableClassInitialization.checkEagerInitialization(clazz);
        if (!UNSAFE.shouldBeInitialized(clazz)) {
            throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName() + " for reason: " + reason);
        }
        this.computeInitKindAndMaybeInitializeClass(clazz, false);
        InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RUN_TIME);
        if (previousKind == InitKind.BUILD_TIME) {
            throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName() + " for reason: " + reason);
        }
        if (previousKind == InitKind.RERUN) {
            throw UserError.abort("Class is registered both for delaying and rerunning the class initializer: " + clazz.getTypeName() + " for reason: " + reason);
        }
    }

    public void rerunInitialization(Class<?> clazz, String reason) {
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RERUN, reason);
        ConfigurableClassInitialization.checkEagerInitialization(clazz);
        try {
            UNSAFE.ensureClassInitialized(clazz);
        }
        catch (Throwable ex) {
            throw UserError.abort("Class initialization failed: " + clazz.getTypeName(), ex);
        }
        this.computeInitKindAndMaybeInitializeClass(clazz, false);
        InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RERUN);
        if (previousKind != null) {
            if (previousKind == InitKind.BUILD_TIME) {
                throw UserError.abort("The information that the class should be initialized during image building has already been used, so it is too late to register re-running the class initializer: " + clazz.getTypeName() + " for reason: " + reason);
            }
            if (previousKind.isDelayed()) {
                throw UserError.abort("Class or a superclass is already registered for delaying the class initializer, so it is too late to register re-running the class initializer: " + clazz.getTypeName() + " for reason: " + reason);
            }
        }
    }

    public void initializeAtBuildTime(Class<?> aClass, String reason) {
        this.classInitializationConfiguration.insert(aClass.getTypeName(), InitKind.BUILD_TIME, reason);
        this.forceInitializeHosted(aClass, reason, false);
    }

    private void setKindForSubclasses(Class<?> clazz, InitKind kind) {
        this.loader.findSubclasses(clazz, false).stream().filter(c -> !c.equals(clazz)).filter(c -> !c.isInterface() || ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(c))).forEach(c -> this.classInitializationConfiguration.insert(c.getTypeName(), kind, "subtype of " + clazz.getTypeName()));
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz, String reason, boolean allowInitializationErrors) {
        if (clazz == null) {
            return;
        }
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.BUILD_TIME, reason);
        InitKind initKind = this.ensureClassInitialized(clazz, allowInitializationErrors);
        this.classInitKinds.put(clazz, initKind);
        this.forceInitializeHosted(clazz.getSuperclass(), "super type of " + clazz.getTypeName(), allowInitializationErrors);
        this.forceInitializeInterfaces(clazz.getInterfaces(), "super type of " + clazz.getTypeName());
    }

    private void forceInitializeInterfaces(Class<?>[] interfaces, String reason) {
        for (Class<?> iface : interfaces) {
            if (ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(iface))) {
                this.classInitializationConfiguration.insert(iface.getTypeName(), InitKind.BUILD_TIME, reason);
                this.ensureClassInitialized(iface, false);
                this.classInitKinds.put(iface, InitKind.BUILD_TIME);
            }
            this.forceInitializeInterfaces(iface.getInterfaces(), "super type of " + iface.getTypeName());
        }
    }

    @Override
    public boolean checkDelayedInitialization() {
        for (Map.Entry<Class<?>, InitKind> entry : this.classInitKinds.entrySet()) {
            if (!entry.getValue().isDelayed() || UNSAFE.shouldBeInitialized(entry.getKey())) continue;
            throw UserError.abort("Class that is marked for delaying initialization to run time got initialized during image building: " + entry.getKey().getTypeName() + ". Try marking this class for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationFeature.Options.ClassInitialization, entry.getKey().getTypeName(), "initialize-at-build-time"));
        }
        return true;
    }

    private static void checkEagerInitialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw UserError.abort("Primitive types and array classes are initialized eagerly because initialization is side-effect free. It is not possible (and also not useful) to register them for run time initialization: " + clazz.getTypeName());
        }
        if (clazz.isAnnotation()) {
            throw UserError.abort("Class initialization of annotation classes cannot be delayed to runtime. Culprit: " + clazz.getTypeName());
        }
    }

    @Override
    public List<ClassOrPackageConfig> getClassInitializationConfiguration() {
        return this.classInitializationConfiguration.allConfigs();
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoize) {
        if (this.classInitKinds.containsKey(clazz)) {
            return this.classInitKinds.get(clazz);
        }
        if (clazz.isAnnotation()) {
            this.forceInitializeHosted(clazz, "all annotations are initialized", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.isEnum() && !UNSAFE.shouldBeInitialized(clazz)) {
            if (memoize) {
                this.forceInitializeHosted(clazz, "enums referred in annotations must be initialized", false);
            }
            return InitKind.BUILD_TIME;
        }
        if (clazz.getTypeName().contains("$$Lambda$")) {
            if (memoize) {
                this.forceInitializeHosted(clazz, "lambdas must be initialized", false);
            }
            return InitKind.BUILD_TIME;
        }
        InitKind result = this.computeInitKindForClass(clazz);
        if (clazz.getSuperclass() != null) {
            result = result.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoize));
        }
        result = result.max(this.processInterfaces(clazz, memoize));
        if (memoize) {
            if (!result.isDelayed()) {
                result = result.max(this.ensureClassInitialized(clazz, false));
            }
            InitKind previous = this.classInitKinds.put(clazz, result);
            assert (previous == null || previous == result) : "Overwriting existing value";
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        InitKind result = this.computeInitKindForClass(clazz);
        for (Class<?> iface : clazz.getInterfaces()) {
            result = ClassInitializationFeature.declaresDefaultMethods(this.metaAccess.lookupJavaType(iface)) ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    private InitKind computeInitKindForClass(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return InitKind.BUILD_TIME;
        }
        if (clazz.isAnnotation()) {
            return InitKind.BUILD_TIME;
        }
        if (Proxy.isProxyClass(clazz)) {
            return InitKind.BUILD_TIME;
        }
        if (clazz.getTypeName().contains("$$Lambda$")) {
            return InitKind.BUILD_TIME;
        }
        if (clazz.getTypeName().contains("$$StringConcat")) {
            return InitKind.BUILD_TIME;
        }
        if (this.specifiedInitKindFor(clazz) != null) {
            return this.specifiedInitKindFor(clazz);
        }
        ClassLoader typeClassLoader = clazz.getClassLoader();
        if (typeClassLoader == null || typeClassLoader == NativeImageGenerator.class.getClassLoader() || typeClassLoader == SunJCE.class.getClassLoader() || typeClassLoader == OptionKey.class.getClassLoader()) {
            return InitKind.BUILD_TIME;
        }
        return InitKind.RUN_TIME;
    }
}

