/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.UnsignedWord;

@Platforms(value={Platform.WINDOWS.class})
class WindowsStackOverflowSupport
implements StackOverflowCheck.OSSupport {
    WindowsStackOverflowSupport() {
    }

    @Override
    @NeverInline(value="GR-16537")
    @Uninterruptible(reason="Called while thread is being attached to the VM, i.e., when the thread state is not yet set up.")
    public UnsignedWord lookupStackEnd() {
        WinBase.MEMORY_BASIC_INFORMATION minfo = (WinBase.MEMORY_BASIC_INFORMATION)StackValue.get(WinBase.MEMORY_BASIC_INFORMATION.class);
        WinBase.VirtualQuery(minfo, minfo, SizeOf.unsigned(WinBase.MEMORY_BASIC_INFORMATION.class));
        return minfo.AllocationBase();
    }
}

