/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.net.InetAddress;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="net", requireStatic=true)
class WindowsJavaNetSubstitutionsFeature
implements Feature {
    WindowsJavaNetSubstitutionsFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        try {
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.InetAddress"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.Inet4AddressImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.Inet6AddressImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.SocketInputStream"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.SocketOutputStream"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.NetworkInterface"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.DatagramPacket"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.AbstractPlainSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.DualStackPlainSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.TwoStacksPlainSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.DualStackPlainDatagramSocketImpl"), "required for substitutions");
            ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl"), "required for substitutions");
        }
        catch (Exception e) {
            VMError.shouldNotReachHere("WindowsJavaNetSubstitutionsFeature: Error registering rerunClassInitialization: ", e);
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("name"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("displayName"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("index"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("addrs"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("bindings"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredField("childs"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.NetworkInterface").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredField("broadcast"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InterfaceAddress").getDeclaredField("maskLength"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredField("holder"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredField("preferIPv6Address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress").getDeclaredMethod("anyLocalAddress", new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddressContainer").getDeclaredField("addr"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("family"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("hostName"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetAddress$InetAddressHolder").getDeclaredField("originalHostName"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet4Address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet4Address").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address").getDeclaredField("holder6"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address").getDeclaredField("cached_scope_id"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address").getDeclaredConstructor(new Class[0]));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("ipaddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("scope_id"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("scope_id_set"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.Inet6Address$Inet6AddressHolder").getDeclaredField("scope_ifname"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("port"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("buf"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("offset"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("length"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramPacket").getDeclaredField("bufLength"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.InetSocketAddress").getDeclaredConstructor(InetAddress.class, Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketException").getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.ConnectException").getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.BindException").getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.UnknownHostException").getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(String.class.getDeclaredConstructor(byte[].class, String.class));
            JNIRuntimeAccess.register(String.class.getDeclaredMethod("getBytes", String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketInputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketOutputStream"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DualStackPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl").getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.DatagramSocketImpl").getDeclaredField("localPort"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("timeout"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("trafficClass"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainDatagramSocketImpl").getDeclaredField("connected"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl").getDeclaredField("fd1"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl").getDeclaredField("fduse"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainDatagramSocketImpl").getDeclaredField("lastfd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("localport"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("serverSocket"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("address"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.SocketImpl").getDeclaredField("port"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl").getDeclaredField("timeout"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.AbstractPlainSocketImpl").getDeclaredField("trafficClass"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainSocketImpl"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainSocketImpl").getDeclaredField("fd1"));
            JNIRuntimeAccess.register(access.findClassByName("java.net.TwoStacksPlainSocketImpl").getDeclaredField("lastfd"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredConstructor(Integer.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Integer").getDeclaredField("value"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean"));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredConstructor(Boolean.TYPE));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.Boolean").getDeclaredMethod("getBoolean", String.class));
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.InetAddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.register((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet4AddressImpl")});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{access.findClassByName("java.net.Inet6AddressImpl")});
        }
        catch (Exception e) {
            VMError.shouldNotReachHere("WindowsJavaNetSubstitutionsFeature: Error registering class or method: ", e);
        }
    }
}

