/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="java", requireStatic=true)
class WindowsJavaIOSubstituteFeature
implements Feature {
    WindowsJavaIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.io.RandomAccessFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.ZipFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Inflater"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Deflater"), "required for substitutions");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(String.class);
            JNIRuntimeAccess.register(access.findClassByName("java.io.WinNTFileSystem"));
            JNIRuntimeAccess.register(IOException.class.getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(File.class.getDeclaredField("path"));
            JNIRuntimeAccess.register(FileOutputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileInputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("handle"));
            JNIRuntimeAccess.register(RandomAccessFile.class.getDeclaredField("fd"));
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            VMError.shouldNotReachHere("WindowsJavaIOSubstitutionFeature: Error registering class or method: ", e);
        }
    }
}

