/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.OS;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public final class ClasspathUtils {
    public static final String cpWildcardSubstitute = "$JavaCla$$pathWildcard$ubstitute$";

    public static Path stringToClasspath(String cp) {
        String separators = Pattern.quote(File.separator);
        if (OS.getCurrent().equals((Object)OS.WINDOWS)) {
            separators = separators + "/";
        }
        CharSequence[] components = cp.split("[" + separators + "]", Integer.MAX_VALUE);
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals("*")) continue;
            components[i] = cpWildcardSubstitute;
        }
        return Paths.get(String.join((CharSequence)File.separator, components), new String[0]);
    }

    public static String classpathToString(Path cp) {
        CharSequence[] components = cp.toString().split(Pattern.quote(File.separator), Integer.MAX_VALUE);
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].equals(cpWildcardSubstitute)) continue;
            components[i] = "*";
        }
        return String.join((CharSequence)File.separator, components);
    }
}

