/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.Inflater;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={InternalPlatform.LINUX_JNI.class, InternalPlatform.DARWIN_JNI.class})
@AutomaticFeature
@CLibrary(value="java", requireStatic=true)
class PosixJavaIOSubstituteFeature
implements Feature {
    PosixJavaIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.io.RandomAccessFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.ZipFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Inflater"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Deflater"), "required for substitutions");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(String.class);
            JNIRuntimeAccess.register(access.findClassByName("java.lang.String").getDeclaredConstructor(byte[].class, String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.lang.String").getDeclaredMethod("getBytes", String.class));
            JNIRuntimeAccess.register(File.class);
            JNIRuntimeAccess.register(File.class.getDeclaredField("path"));
            JNIRuntimeAccess.register(FileOutputStream.class);
            JNIRuntimeAccess.register(FileOutputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileInputStream.class);
            JNIRuntimeAccess.register(FileInputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class);
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("fd"));
            if (JavaVersionUtil.JAVA_SPEC > 8) {
                JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("append"));
            }
            JNIRuntimeAccess.register(RandomAccessFile.class);
            JNIRuntimeAccess.register(RandomAccessFile.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(IOException.class);
            JNIRuntimeAccess.register(IOException.class.getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(access.findClassByName("java.io.UnixFileSystem"));
            if (JavaVersionUtil.JAVA_SPEC >= 11) {
                JNIRuntimeAccess.register(Inflater.class.getDeclaredField("inputConsumed"));
                JNIRuntimeAccess.register(Inflater.class.getDeclaredField("outputConsumed"));
            }
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            VMError.shouldNotReachHere("PosixJavaIOSubstitutionFeature: Error registering class or method: ", e);
        }
    }
}

