/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.jdk.BuildStackTraceVisitor;
import com.oracle.svm.core.jdk.GetCallerClassVisitor;
import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.stack.JavaStackWalker;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.util.DirectAnnotationAccess;
import org.graalvm.word.Pointer;

public class StackTraceUtils {
    public static StackTraceElement[] getStackTrace(boolean filterExceptions, Pointer startSP, CodePointer startIP) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions);
        JavaStackWalker.walkCurrentThread(startSP, startIP, visitor);
        return visitor.trace.toArray(new StackTraceElement[0]);
    }

    public static StackTraceElement[] getStackTrace(boolean filterExceptions, IsolateThread thread) {
        BuildStackTraceVisitor visitor = new BuildStackTraceVisitor(filterExceptions);
        JavaStackWalker.walkThread(thread, visitor);
        return visitor.trace.toArray(new StackTraceElement[0]);
    }

    public static Class<?> getCallerClass(Pointer startSP, CodePointer startIP) {
        GetCallerClassVisitor visitor = new GetCallerClassVisitor();
        JavaStackWalker.walkCurrentThread(startSP, startIP, visitor);
        return visitor.result;
    }

    public static boolean shouldShowFrame(FrameInfoQueryResult frameInfo, boolean showReflectFrames, boolean showHiddenFrames) {
        if (showHiddenFrames) {
            return true;
        }
        Class<?> clazz = frameInfo.getSourceClass();
        if (clazz == null) {
            return false;
        }
        if (DirectAnnotationAccess.isAnnotationPresent(clazz, InternalVMMethod.class)) {
            return false;
        }
        return showReflectFrames || !(clazz == Method.class && "invoke".equals(frameInfo.getSourceMethodName()) || clazz == Constructor.class && "newInstance".equals(frameInfo.getSourceMethodName())) && (clazz != Class.class || !"newInstance".equals(frameInfo.getSourceMethodName()));
    }
}

