/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.util.VMError;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={InternalPlatform.LINUX_JNI.class, InternalPlatform.DARWIN_JNI.class, Platform.WINDOWS.class})
@AutomaticFeature
class JDKLibZipFeature
implements Feature {
    JDKLibZipFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.ZipFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Inflater"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Deflater"), "required for substitutions");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("needDict"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("finished"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("buf"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("off"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("len"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("level"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("strategy"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("setParams"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("finish"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("finished"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("buf"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("off"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("len"));
        }
        catch (NoSuchFieldException e) {
            VMError.shouldNotReachHere("LibZipFeature: Error in registering jni access:", e);
        }
    }
}

