/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.meta;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfoEncoder;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.DeoptimizationSourcePositionEncoder;
import com.oracle.svm.core.code.FrameInfoEncoder;
import com.oracle.svm.core.code.InstalledCodeObserver;
import com.oracle.svm.core.code.InstalledCodeObserverSupport;
import com.oracle.svm.core.code.RuntimeMethodInfo;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.deopt.SubstrateInstalledCode;
import com.oracle.svm.core.graal.code.NativeImagePatcher;
import com.oracle.svm.core.graal.code.SubstrateCompilationResult;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.heap.CodeReferenceMapDecoder;
import com.oracle.svm.core.heap.CodeReferenceMapEncoder;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.ObjectReferenceWalker;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.heap.ReferenceAccess;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataPatch;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class InstalledCodeBuilder {
    private final SharedRuntimeMethod method;
    private final SubstrateInstalledCode installedCode;
    private final int tier;
    private final Map<SharedMethod, InstalledCodeBuilder> allInstalledCode;
    protected Pointer code;
    private final int codeSize;
    private final int constantsOffset;
    private final InstalledCodeObserver[] codeObservers;
    private SubstrateCompilationResult compilation;
    private byte[] compiledBytes;
    private final PinnedAllocator metaInfoAllocator;
    private RuntimeMethodInfo runtimeMethodInfo;
    private ConstantsWalker constantsWalker;
    private final boolean testTrampolineJumps;
    static final int TRAMPOLINE_JUMP_SIZE = 6;

    public InstalledCodeBuilder(SharedRuntimeMethod method, CompilationResult compilation, SubstrateInstalledCode installedCode, Map<SharedMethod, InstalledCodeBuilder> allInstalledCode) {
        this(method, compilation, installedCode, allInstalledCode, false);
    }

    public InstalledCodeBuilder(SharedRuntimeMethod method, CompilationResult compilation, SubstrateInstalledCode installedCode, Map<SharedMethod, InstalledCodeBuilder> allInstalledCode, boolean testTrampolineJumps) {
        this.method = method;
        this.compilation = (SubstrateCompilationResult)compilation;
        this.tier = compilation.getName().endsWith("#1") ? 1 : 2;
        this.installedCode = installedCode;
        this.allInstalledCode = allInstalledCode;
        this.testTrampolineJumps = testTrampolineJumps;
        this.metaInfoAllocator = Heap.getHeap().createPinnedAllocator();
        DebugContext debug = DebugContext.forCurrentThread();
        try (Indent indent = debug.logAndIndent("create installed code of %s.%s", (Object)method.getDeclaringClass().getName(), (Object)method.getName());){
            SubstrateTargetDescription target = ConfigurationValues.getTarget();
            if (target.arch.getPlatformKind(JavaKind.Object).getSizeInBytes() != 8) {
                throw VMError.shouldNotReachHere("wrong object size");
            }
            int constantsSize = compilation.getDataSection().getSectionSize();
            this.codeSize = compilation.getTargetCodeSize();
            int tmpConstantsOffset = NumUtil.roundUp((int)this.codeSize, (int)compilation.getDataSection().getSectionAlignment());
            int tmpMemorySize = tmpConstantsOffset + constantsSize;
            this.code = InstalledCodeBuilder.allocateOSMemory(WordFactory.unsigned((int)tmpMemorySize));
            HashSet<Long> directTargets = new HashSet<Long>();
            boolean needTrampolineJumps = testTrampolineJumps;
            for (Infopoint infopoint : compilation.getInfopoints()) {
                if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
                Call call = (Call)infopoint;
                long targetAddress = this.getTargetCodeAddress(call);
                long pcDisplacement = targetAddress - (this.code.rawValue() + (long)call.pcOffset);
                if (pcDisplacement != (long)((int)pcDisplacement)) {
                    needTrampolineJumps = true;
                }
                directTargets.add(targetAddress);
            }
            this.compiledBytes = compilation.getTargetCode();
            if (needTrampolineJumps) {
                InstalledCodeBuilder.freeOSMemory(this.code, WordFactory.unsigned((int)tmpMemorySize));
                tmpConstantsOffset = NumUtil.roundUp((int)(this.codeSize + directTargets.size() * 6), (int)8);
                tmpConstantsOffset = NumUtil.roundUp((int)(tmpConstantsOffset + directTargets.size() * 8), (int)compilation.getDataSection().getSectionAlignment());
                if (tmpConstantsOffset > this.compiledBytes.length) {
                    this.compiledBytes = Arrays.copyOf(this.compiledBytes, tmpConstantsOffset);
                }
                tmpMemorySize = tmpConstantsOffset + constantsSize;
                this.code = InstalledCodeBuilder.allocateOSMemory(WordFactory.unsigned((int)tmpMemorySize));
            }
            this.constantsOffset = tmpConstantsOffset;
            this.codeObservers = ((InstalledCodeObserverSupport)ImageSingletons.lookup(InstalledCodeObserverSupport.class)).createObservers(debug, method, compilation, this.code);
        }
    }

    public SubstrateInstalledCode getInstalledCode() {
        return this.installedCode;
    }

    public void install() {
        this.installOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installOperation() {
        ObjectConstantsHolder objectConstants = new ObjectConstantsHolder(this.compilation);
        HashMap<Integer, NativeImagePatcher> patches = new HashMap<Integer, NativeImagePatcher>();
        for (CompilationResult.CodeAnnotation codeAnnotation : this.compilation.getCodeAnnotations()) {
            if (!(codeAnnotation instanceof NativeImagePatcher)) continue;
            patches.put(codeAnnotation.position, (NativeImagePatcher)codeAnnotation);
        }
        this.patchData(patches, objectConstants);
        int updatedCodeSize = this.patchCalls(patches);
        assert (updatedCodeSize <= this.constantsOffset);
        for (int index = 0; index < updatedCodeSize; ++index) {
            this.code.writeByte(index, this.compiledBytes[index]);
        }
        ByteBuffer constantsBuffer = CTypeConversion.asByteBuffer((PointerBase)this.code.add(this.constantsOffset), (int)this.compilation.getDataSection().getSectionSize());
        this.compilation.getDataSection().buildDataSection(constantsBuffer, (position, constant) -> objectConstants.add(new DataSectionPatcher(this.constantsOffset + position), (SubstrateObjectConstant)constant));
        this.metaInfoAllocator.open();
        try {
            this.runtimeMethodInfo = this.metaInfoAllocator.newInstance(RuntimeMethodInfo.class);
            this.constantsWalker = this.metaInfoAllocator.newInstance(ConstantsWalker.class);
            CodeReferenceMapEncoder encoder = new CodeReferenceMapEncoder();
            encoder.add(objectConstants.referenceMap);
            this.constantsWalker.referenceMapEncoding = encoder.encodeAll(this.metaInfoAllocator);
            this.constantsWalker.referenceMapIndex = encoder.lookupEncoding(objectConstants.referenceMap);
            this.constantsWalker.baseAddr = this.code;
            this.constantsWalker.size = this.codeSize;
            Heap.getHeap().getGC().registerObjectReferenceWalker(this.constantsWalker);
            try (NoAllocationVerifier verifier = NoAllocationVerifier.factory("InstalledCodeBuilder.install");){
                this.writeObjectConstantsToCode(objectConstants);
            }
            this.createCodeChunkInfos();
            InstalledCodeObserver.InstalledCodeObserverHandle[] observerHandles = InstalledCodeObserverSupport.installObservers(this.codeObservers, this.metaInfoAllocator);
            this.runtimeMethodInfo.setData((CodePointer)this.code, WordFactory.unsigned((int)this.codeSize), this.installedCode, this.tier, this.constantsWalker, this.metaInfoAllocator, observerHandles);
        }
        finally {
            this.metaInfoAllocator.close();
        }
        Throwable[] errorBox = new Throwable[]{null};
        VMOperation.enqueueBlockingSafepoint("Install code", () -> {
            try {
                CodeInfoTable.getRuntimeCodeCache().addMethod(this.runtimeMethodInfo);
                this.installedCode.setAddress(this.code.rawValue(), this.method);
            }
            catch (Throwable e) {
                errorBox[0] = e;
            }
        });
        if (errorBox[0] != null) {
            throw InstalledCodeBuilder.rethrow(errorBox[0]);
        }
        this.compilation = null;
    }

    static <E extends Throwable> RuntimeException rethrow(Throwable ex) throws E {
        throw ex;
    }

    @Uninterruptible(reason="Operates on raw pointers to objects")
    private void writeObjectConstantsToCode(ObjectConstantsHolder objectConstants) {
        for (int i = 0; i < objectConstants.count; ++i) {
            objectConstants.patchers[i].patchData(this.code, objectConstants.values[i]);
        }
        this.constantsWalker.pointerMapValid = true;
    }

    private void createCodeChunkInfos() {
        CodeInfoEncoder codeInfoEncoder = new CodeInfoEncoder(new FrameInfoEncoder.NamesFromImage(), this.metaInfoAllocator);
        codeInfoEncoder.addMethod(this.method, this.compilation, 0);
        codeInfoEncoder.encodeAll();
        codeInfoEncoder.install(this.runtimeMethodInfo);
        assert (codeInfoEncoder.verifyMethod(this.compilation, 0));
        DeoptimizationSourcePositionEncoder sourcePositionEncoder = new DeoptimizationSourcePositionEncoder(this.metaInfoAllocator);
        sourcePositionEncoder.encode(this.compilation.getDeoptimizationSourcePositions());
        sourcePositionEncoder.install(this.runtimeMethodInfo);
    }

    private void patchData(Map<Integer, NativeImagePatcher> patcher, ObjectConstantsHolder objectConstants) {
        for (DataPatch dataPatch : this.compilation.getDataPatches()) {
            DataSectionReference ref;
            NativeImagePatcher patch = patcher.get(dataPatch.pcOffset);
            if (dataPatch.reference instanceof DataSectionReference) {
                ref = (DataSectionReference)dataPatch.reference;
                int pcDisplacement = this.constantsOffset + ref.getOffset() - dataPatch.pcOffset;
                patch.patch(dataPatch.pcOffset, pcDisplacement, this.compiledBytes);
                continue;
            }
            if (!(dataPatch.reference instanceof ConstantReference)) continue;
            ref = (ConstantReference)dataPatch.reference;
            SubstrateObjectConstant refConst = (SubstrateObjectConstant)ref.getConstant();
            objectConstants.add(patch, refConst);
        }
    }

    private int patchCalls(Map<Integer, NativeImagePatcher> patches) {
        HashMap<Long, Integer> directTargets = new HashMap<Long, Integer>();
        int currentPos = this.codeSize;
        for (Infopoint infopoint : this.compilation.getInfopoints()) {
            if (!(infopoint instanceof Call) || !((Call)infopoint).direct) continue;
            Call call = (Call)infopoint;
            long targetAddress = this.getTargetCodeAddress(call);
            long pcDisplacement = targetAddress - (this.code.rawValue() + (long)call.pcOffset);
            if (pcDisplacement != (long)((int)pcDisplacement) || this.testTrampolineJumps) {
                Long destAddr = targetAddress;
                Integer trampolineOffset = (Integer)directTargets.get(destAddr);
                if (trampolineOffset == null) {
                    trampolineOffset = currentPos;
                    directTargets.put(destAddr, trampolineOffset);
                    currentPos += 6;
                }
                pcDisplacement = trampolineOffset - call.pcOffset;
            }
            assert (pcDisplacement == (long)((int)pcDisplacement));
            patches.get(call.pcOffset).patch(call.pcOffset, (int)pcDisplacement, this.compiledBytes);
        }
        if (directTargets.size() > 0) {
            currentPos = NumUtil.roundUp((int)currentPos, (int)8);
            ByteOrder byteOrder = ConfigurationValues.getTarget().arch.getByteOrder();
            assert (byteOrder == ByteOrder.LITTLE_ENDIAN) : "Code below assumes little-endian byte order";
            ByteBuffer codeBuffer = ByteBuffer.wrap(this.compiledBytes).order(byteOrder);
            for (Map.Entry entry : directTargets.entrySet()) {
                long targetAddress = (Long)entry.getKey();
                int trampolineOffset = (Integer)entry.getValue();
                codeBuffer.put(trampolineOffset + 0, (byte)-1);
                codeBuffer.put(trampolineOffset + 1, (byte)37);
                codeBuffer.putInt(trampolineOffset + 2, currentPos - (trampolineOffset + 6));
                codeBuffer.putLong(currentPos, targetAddress);
                currentPos += 8;
            }
        }
        return currentPos;
    }

    private long getTargetCodeAddress(Call callInfo) {
        SubstrateInstalledCode targetInstalledCode;
        InstalledCodeBuilder targetInstalledCodeBuilder;
        SharedMethod targetMethod = (SharedMethod)callInfo.target;
        long callTargetStart = CodeInfoTable.getImageCodeCache().absoluteIP(targetMethod.getCodeOffsetInImage()).rawValue();
        if (this.allInstalledCode != null && (targetInstalledCodeBuilder = this.allInstalledCode.get(targetMethod)) != null && (targetInstalledCode = targetInstalledCodeBuilder.getInstalledCode()) != null && targetInstalledCode.isValid()) {
            callTargetStart = targetInstalledCode.getAddress();
        }
        if (callTargetStart == 0L) {
            throw VMError.shouldNotReachHere("target method not compiled: " + targetMethod.format("%H.%n(%p)"));
        }
        return callTargetStart;
    }

    private static Pointer allocateOSMemory(UnsignedWord size) {
        Log trace = Log.noopLog();
        trace.string("[SubstrateInstalledCode.allocateAlignedMemory:");
        trace.string("  size: ").unsigned((WordBase)size);
        Pointer result = CommittedMemoryProvider.get().allocate(size, CommittedMemoryProvider.UNALIGNED, true);
        trace.string("  returns: ").hex((WordBase)result);
        trace.string("]").newline();
        if (result.isNull()) {
            throw new OutOfMemoryError();
        }
        return result;
    }

    private static void freeOSMemory(Pointer start, UnsignedWord size) {
        Log trace = Log.noopLog();
        trace.string("[SubstrateInstalledCode.freeOSMemory:");
        trace.string("  start: ").hex((WordBase)start);
        trace.string("  size: ").unsigned((WordBase)size);
        CommittedMemoryProvider.get().free((PointerBase)start, size, CommittedMemoryProvider.UNALIGNED, true);
        trace.string("]").newline();
    }

    private static class DataSectionPatcher
    implements NativeImagePatcher {
        private final int position;

        DataSectionPatcher(int position) {
            this.position = position;
        }

        @Override
        public void patch(int codePos, int relative, byte[] code) {
            VMError.shouldNotReachHere("Datasection can only be patched with an VM constant");
        }

        @Override
        @Uninterruptible(reason="The patcher is intended to work with raw pointers")
        public void patchData(Pointer pointer, Object object) {
            boolean compressed = ReferenceAccess.singleton().haveCompressedReferences();
            Pointer address = pointer.add(this.position);
            ReferenceAccess.singleton().writeObjectAt(address, object, compressed);
        }

        @Override
        @Uninterruptible(reason=".")
        public int getPosition() {
            return this.position;
        }
    }

    static class ObjectConstantsHolder {
        final SubstrateReferenceMap referenceMap;
        final int[] offsets;
        final NativeImagePatcher[] patchers;
        final Object[] values;
        int count;

        ObjectConstantsHolder(CompilationResult compilation) {
            int maxDataRefs = compilation.getDataSection().getSectionSize() / ConfigurationValues.getObjectLayout().getReferenceSize();
            int maxCodeRefs = compilation.getDataPatches().size();
            this.offsets = new int[maxDataRefs + maxCodeRefs];
            this.patchers = new NativeImagePatcher[this.offsets.length];
            this.values = new Object[this.offsets.length];
            this.referenceMap = new SubstrateReferenceMap();
        }

        void add(NativeImagePatcher patchingAnnotation, SubstrateObjectConstant constant) {
            assert (constant.isCompressed() == ReferenceAccess.singleton().haveCompressedReferences()) : "Object reference constants in code must be compressed";
            this.patchers[this.count] = patchingAnnotation;
            this.values[this.count] = KnownIntrinsics.convertUnknownValue(constant.getObject(), Object.class);
            this.referenceMap.markReferenceAtOffset(patchingAnnotation.getPosition(), true);
            ++this.count;
        }
    }

    public static class ConstantsWalker
    extends ObjectReferenceWalker {
        Pointer baseAddr;
        int size;
        byte[] referenceMapEncoding;
        long referenceMapIndex;
        boolean pointerMapValid;

        @Override
        public boolean walk(ObjectReferenceVisitor referenceVisitor) {
            if (this.pointerMapValid) {
                return CodeReferenceMapDecoder.walkOffsetsFromPointer((PointerBase)this.baseAddr, this.referenceMapEncoding, this.referenceMapIndex, referenceVisitor);
            }
            return false;
        }
    }
}

