/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapChunk {
    public static boolean walkObjectsFrom(Header<?> that, Pointer offset, ObjectVisitor visitor) {
        Object obj;
        Log trace = Log.noopLog().string("[HeapChunk.walkObjectsFrom:");
        trace.string("  that: ").hex((WordBase)that).string("  offset: ").hex((WordBase)offset).string("  getTop(): ").hex((WordBase)that.getTop());
        Object object = obj = offset.belowThan((UnsignedWord)that.getTop()) ? offset.toObject() : null;
        while (obj != null) {
            trace.newline().string("  o: ").object(obj).newline();
            if (!visitor.visitObjectInline(obj)) {
                trace.string("  visitObject fails").string("  returns false").string("]").newline();
                return false;
            }
            obj = HeapChunk.getNextObject(that, obj);
        }
        trace.string("  returns true").string("]").newline();
        return true;
    }

    private static Object getNextObject(Header<?> that, Object obj) {
        Log trace = Log.noopLog().string("[HeapChunk.getNextObject:").newline();
        Pointer objEnd = LayoutEncoding.getObjectEnd(obj);
        trace.string("  o: ").object(obj).string("  objEnd: ").hex((WordBase)objEnd).string("  top: ").hex((WordBase)that.getTop()).newline();
        if (that.getTop().belowOrEqual((UnsignedWord)objEnd)) {
            trace.string("  returns null").string("]").newline();
            return null;
        }
        Object result = objEnd.toObject();
        trace.string(" returns ").object(result).string("]").newline();
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public static UnsignedWord availableObjectMemory(Header<?> that) {
        Pointer top = that.getTop();
        Pointer end = that.getEnd();
        return end.subtract((UnsignedWord)top);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    protected static void setTopCarefully(Header<?> that, Pointer newTop) {
        assert (that.getTop().belowOrEqual((UnsignedWord)newTop)) : "newTop too low.";
        assert (newTop.belowOrEqual((UnsignedWord)that.getEnd())) : "newTop too high.";
        that.setTop(newTop);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static Pointer asPointer(Header<?> that) {
        return (Pointer)that;
    }

    static boolean verifyHeapChunk(Header<?> that, Pointer start) {
        Log trace = HeapImpl.getHeapImpl().getHeapVerifierImpl().getTraceLog().string("[HeapChunk.verify:");
        trace.string("  that:  ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)that.getTop()).string("  end: ").hex((WordBase)that.getEnd());
        Pointer p = start;
        while (p.belowThan((UnsignedWord)that.getTop())) {
            if (!HeapImpl.getHeapImpl().getHeapVerifierImpl().verifyObjectAt(p)) {
                Log witness = HeapImpl.getHeapImpl().getHeapVerifierImpl().getWitnessLog().string("[HeapChunk.verify:");
                witness.string("  that:  ").hex((WordBase)that).string("  start: ").hex((WordBase)start).string("  top: ").hex((WordBase)that.getTop()).string("  end: ").hex((WordBase)that.getEnd());
                witness.string("  space: ").string(that.getSpace().getName());
                witness.string("  object at p: ").hex((WordBase)p).string("  fails to verify").string("]").newline();
                trace.string("  returns false]").newline();
                return false;
            }
            UnsignedWord header = ObjectHeaderImpl.readHeaderFromPointerCarefully(p);
            Object o = ObjectHeaderImpl.getObjectHeaderImpl().isForwardedHeaderCarefully(header) ? ObjectHeaderImpl.getObjectHeaderImpl().getForwardedObject(p) : p.toObject();
            p = p.add(LayoutEncoding.getSizeFromObject(o));
        }
        trace.string("  returns true]").newline();
        return true;
    }

    public static abstract class MemoryWalkerAccessImpl<T extends Header<?>>
    implements MemoryWalker.HeapChunkAccess<T> {
        @Platforms(value={Platform.HOSTED_ONLY.class})
        protected MemoryWalkerAccessImpl() {
        }

        @Override
        public UnsignedWord getStart(T heapChunk) {
            return (UnsignedWord)heapChunk;
        }

        @Override
        public UnsignedWord getSize(T heapChunk) {
            return heapChunk.getEnd().subtract(this.getStart(heapChunk));
        }

        @Override
        public UnsignedWord getAllocationEnd(T heapChunk) {
            return heapChunk.getTop();
        }

        @Override
        public String getRegion(T heapChunk) {
            Space space = heapChunk.getSpace();
            String result = space == null ? "free" : (space.isYoungSpace() ? "young" : "old");
            return result;
        }

        @Override
        public boolean isPinned(T heapChunk) {
            return heapChunk.getSpace() == HeapImpl.getHeapImpl().getOldGeneration().getPinnedFromSpace();
        }
    }

    @RawStructure
    public static interface Header<T extends Header<T>>
    extends PointerBase {
        @RawField
        @UniqueLocationIdentity
        public Pointer getTop();

        @RawField
        @UniqueLocationIdentity
        public void setTop(Pointer var1);

        @RawField
        @UniqueLocationIdentity
        public Pointer getEnd();

        @RawField
        @UniqueLocationIdentity
        public void setEnd(Pointer var1);

        @RawField
        @UniqueLocationIdentity
        public boolean getPinned();

        @RawField
        @UniqueLocationIdentity
        public void setPinned(boolean var1);

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public Space getSpace();

        @RawField
        @UniqueLocationIdentity
        @PinnedObjectField
        public void setSpace(Space var1);

        @RawField
        @UniqueLocationIdentity
        public T getPrevious();

        @RawField
        @UniqueLocationIdentity
        public void setPrevious(T var1);

        @RawField
        @UniqueLocationIdentity
        public T getNext();

        @RawField
        @UniqueLocationIdentity
        public void setNext(T var1);
    }
}

