/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.aarch64;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.SubstrateOptions;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordBase;

public class AArch64FrameAccess
extends FrameAccess {
    @Override
    public CodePointer readReturnAddress(Pointer sourceSp) {
        return (CodePointer)sourceSp.readWord(-AArch64FrameAccess.returnAddressSize());
    }

    @Override
    public void writeReturnAddress(Pointer sourceSp, CodePointer newReturnAddress) {
        sourceSp.writeWord(-AArch64FrameAccess.returnAddressSize(), (WordBase)newReturnAddress);
    }

    @Override
    @Fold
    public int savedBasePointerSize() {
        if (SubstrateOptions.UseStackBasePointer.getValue().booleanValue()) {
            return AArch64FrameAccess.wordSize();
        }
        return 0;
    }
}

