/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.functions;

import com.oracle.svm.core.MonitorSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.util.Utf8;
import com.oracle.svm.jni.JNIJavaVMList;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.JNIThreadLocalEnvironment;
import com.oracle.svm.jni.JNIThreadOwnedMonitors;
import com.oracle.svm.jni.functions.JNIFunctionTables;
import com.oracle.svm.jni.functions.JNIFunctions;
import com.oracle.svm.jni.nativeapi.JNIEnvironmentPointer;
import com.oracle.svm.jni.nativeapi.JNIErrors;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIJavaVMAttachArgs;
import com.oracle.svm.jni.nativeapi.JNIJavaVMInitArgs;
import com.oracle.svm.jni.nativeapi.JNIJavaVMOption;
import com.oracle.svm.jni.nativeapi.JNIJavaVMPointer;
import com.oracle.svm.jni.nativeapi.JNIVersion;
import java.io.CharConversionException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

final class JNIInvocationInterface {
    JNIInvocationInterface() {
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static int AttachCurrentThread(JNIJavaVM vm, JNIEnvironmentPointer penv, JNIJavaVMAttachArgs args) {
        return Support.attachCurrentThread(vm, penv, args, false);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static int AttachCurrentThreadAsDaemon(JNIJavaVM vm, JNIEnvironmentPointer penv, JNIJavaVMAttachArgs args) {
        return Support.attachCurrentThread(vm, penv, args, true);
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadPrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static int DetachCurrentThread(JNIJavaVM vm) {
        int result = JNIErrors.JNI_OK();
        if (!vm.equal((ComparableWord)JNIFunctionTables.singleton().getGlobalJavaVM())) {
            result = JNIErrors.JNI_ERR();
        }
        Support.releaseCurrentThreadOwnedMonitors();
        return result;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=JNIFunctions.Support.JNIJavaVMEnterAttachThreadPrologue.class, epilogue=CEntryPointSetup.LeaveTearDownIsolateEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static int DestroyJavaVM(JNIJavaVM vm) {
        JavaThreads.singleton().joinAllNonDaemons();
        return JNIErrors.JNI_OK();
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=Support.JNIGetEnvPrologue.class, publishAs=CEntryPointOptions.Publish.NotPublished, include=CEntryPointOptions.NotIncludedAutomatically.class)
    static int GetEnv(JNIJavaVM vm, WordPointer env, int version) {
        env.write((WordBase)JNIThreadLocalEnvironment.getAddress());
        return JNIErrors.JNI_OK();
    }

    static class Support {
        Support() {
        }

        static int attachCurrentThread(JNIJavaVM vm, JNIEnvironmentPointer penv, JNIJavaVMAttachArgs args, boolean asDaemon) {
            if (vm.equal((ComparableWord)JNIFunctionTables.singleton().getGlobalJavaVM())) {
                penv.write(JNIThreadLocalEnvironment.getAddress());
                ThreadGroup group2 = null;
                String name = null;
                if (args.isNonNull() && args.getVersion() != JNIVersion.JNI_VERSION_1_1()) {
                    group2 = (ThreadGroup)JNIObjectHandles.getObject(args.getGroup());
                    if (args.getName().isNonNull()) {
                        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)args.getName(), (int)Integer.MAX_VALUE);
                        try {
                            name = Utf8.utf8ToString(true, buffer);
                        }
                        catch (CharConversionException charConversionException) {
                            // empty catch block
                        }
                    }
                }
                JavaThreads.singleton().assignJavaThread(name, group2, asDaemon);
                return JNIErrors.JNI_OK();
            }
            return JNIErrors.JNI_ERR();
        }

        static void releaseCurrentThreadOwnedMonitors() {
            JNIThreadOwnedMonitors.forEach((obj, depth) -> {
                for (int i = 0; i < depth; ++i) {
                    MonitorSupport.monitorExit(obj);
                }
                assert (!Thread.holdsLock(obj));
            });
        }

        public static JNIJavaVM getGlobalJavaVM() {
            return JNIFunctionTables.singleton().getGlobalJavaVM();
        }

        static class JNIGetEnvPrologue {
            JNIGetEnvPrologue() {
            }

            static void enter(JNIJavaVM vm, WordPointer env, int version) {
                if (vm.isNull() || env.isNull()) {
                    CEntryPointActions.bailoutInPrologue(JNIErrors.JNI_ERR());
                }
                if (version != JNIVersion.JNI_VERSION_1_8() && version != JNIVersion.JNI_VERSION_1_6() && version != JNIVersion.JNI_VERSION_1_4() && version != JNIVersion.JNI_VERSION_1_2() && version != JNIVersion.JNI_VERSION_1_1()) {
                    env.write((WordBase)WordFactory.nullPointer());
                    CEntryPointActions.bailoutInPrologue(JNIErrors.JNI_EVERSION());
                }
                if (!CEntryPointActions.isCurrentThreadAttachedTo(vm.getFunctions().getIsolate())) {
                    env.write((WordBase)WordFactory.nullPointer());
                    CEntryPointActions.bailoutInPrologue(JNIErrors.JNI_EDETACHED());
                }
                if (CEntryPointActions.enterIsolate(vm.getFunctions().getIsolate()) != 0) {
                    CEntryPointActions.bailoutInPrologue(JNIErrors.JNI_ERR());
                }
            }
        }
    }

    static class Exports {
        Exports() {
        }

        @CEntryPoint(name="JNI_GetCreatedJavaVMs")
        @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.SymbolOnly, include=CEntryPointOptions.NotIncludedAutomatically.class)
        @Uninterruptible(reason="No Java context.")
        static int JNI_GetCreatedJavaVMs(JNIJavaVMPointer vmBuf, int bufLen, CIntPointer nVMs) {
            JNIJavaVMList.gather(vmBuf, bufLen, nVMs);
            return JNIErrors.JNI_OK();
        }

        @CEntryPoint(name="JNI_CreateJavaVM")
        @CEntryPointOptions(prologue=JNICreateJavaVMPrologue.class, publishAs=CEntryPointOptions.Publish.SymbolOnly, include=CEntryPointOptions.NotIncludedAutomatically.class)
        static int JNI_CreateJavaVM(JNIJavaVMPointer vmBuf, JNIEnvironmentPointer penv, JNIJavaVMInitArgs vmArgs) {
            if (vmArgs.isNonNull()) {
                Pointer p = (Pointer)vmArgs.getOptions();
                int count = vmArgs.getNOptions();
                ArrayList<String> options = new ArrayList<String>(count);
                for (int i = 0; i < count; ++i) {
                    JNIJavaVMOption option = (JNIJavaVMOption)p.add(i * SizeOf.get(JNIJavaVMOption.class));
                    CCharPointer str = option.getOptionString();
                    if (!str.isNonNull()) continue;
                    options.add(CTypeConversion.toJavaString((CCharPointer)option.getOptionString()));
                }
                RuntimeOptionParser.parseAndConsumeAllOptions(options.toArray(new String[0]));
            }
            final JNIJavaVM javavm = JNIFunctionTables.singleton().getGlobalJavaVM();
            JNIJavaVMList.addJavaVM(javavm);
            RuntimeSupport.getRuntimeSupport().addTearDownHook(new Runnable(){

                @Override
                public void run() {
                    JNIJavaVMList.removeJavaVM(javavm);
                }
            });
            vmBuf.write(javavm);
            penv.write(JNIThreadLocalEnvironment.getAddress());
            return JNIErrors.JNI_OK();
        }

        @CEntryPoint(name="JNI_GetDefaultJavaVMInitArgs")
        @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.SymbolOnly, include=CEntryPointOptions.NotIncludedAutomatically.class)
        @Uninterruptible(reason="No Java context")
        static int JNI_GetDefaultJavaVMInitArgs(JNIJavaVMInitArgs vmArgs) {
            int version = vmArgs.getVersion();
            if (version == JNIVersion.JNI_VERSION_1_8() || version == JNIVersion.JNI_VERSION_1_6() || version == JNIVersion.JNI_VERSION_1_4() || version == JNIVersion.JNI_VERSION_1_2()) {
                return JNIErrors.JNI_OK();
            }
            if (version == JNIVersion.JNI_VERSION_1_1()) {
                vmArgs.setVersion(JNIVersion.JNI_VERSION_1_2());
            }
            return JNIErrors.JNI_ERR();
        }

        static class JNICreateJavaVMPrologue {
            JNICreateJavaVMPrologue() {
            }

            static void enter(JNIJavaVMPointer vmBuf, JNIEnvironmentPointer penv, JNIJavaVMInitArgs vmArgs) {
                int error;
                if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue() && (error = CEntryPointActions.enterIsolate((Isolate)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL)) != 5) {
                    if (error == 0) {
                        CEntryPointActions.leave();
                    }
                    CEntryPointActions.bailoutInPrologue(JNIErrors.JNI_EEXIST());
                }
                if (CEntryPointActions.enterCreateIsolate((CEntryPointCreateIsolateParameters)WordFactory.nullPointer()) != 0) {
                    CEntryPointActions.bailoutInPrologue(JNIErrors.JNI_ERR());
                }
            }
        }
    }
}

