/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.util.json.JSONParser;
import com.oracle.svm.core.util.json.JSONParserException;
import com.oracle.svm.hosted.ResourcesFeature;
import com.oracle.svm.hosted.config.ConfigurationParser;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class ResourceConfigurationParser
extends ConfigurationParser {
    private final ResourcesFeature.ResourcesRegistry registry;

    public <T> ResourceConfigurationParser(ResourcesFeature.ResourcesRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void parseAndRegister(Reader reader) throws IOException {
        JSONParser parser = new JSONParser(reader);
        Object json = parser.parse();
        this.parseTopLevelObject(ResourceConfigurationParser.asMap(json, "first level of document must be an object"));
    }

    private void parseTopLevelObject(Map<String, Object> obj) {
        Object resourcesObject = null;
        Object bundlesObject = null;
        for (Map.Entry<String, Object> pair : obj.entrySet()) {
            if ("resources".equals(pair.getKey())) {
                resourcesObject = pair.getValue();
                continue;
            }
            if ("bundles".equals(pair.getKey())) {
                bundlesObject = pair.getValue();
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + pair.getKey() + "' (supported attributes: name) in resource definition");
        }
        if (resourcesObject != null) {
            List<Object> resources = ResourceConfigurationParser.asList(resourcesObject, "Attribute 'resources' must be a list of resources");
            for (Object object : resources) {
                ResourceConfigurationParser.parseEntry(object, "pattern", this.registry::addResources, "resource descriptor object", "'resources' list");
            }
        }
        if (bundlesObject != null) {
            List<Object> bundles = ResourceConfigurationParser.asList(bundlesObject, "Attribute 'bundles' must be a list of bundles");
            for (Object object : bundles) {
                ResourceConfigurationParser.parseEntry(object, "name", this.registry::addResourceBundles, "bundle descriptor object", "'bundles' list");
            }
        }
    }

    private static void parseEntry(Object data, String valueKey, Consumer<String> registry, String expectedType, String parentType) {
        Map<String, Object> resource = ResourceConfigurationParser.asMap(data, "Elements of " + parentType + " must be a " + expectedType);
        Object valueObject = null;
        for (Map.Entry<String, Object> pair : resource.entrySet()) {
            if (valueKey.equals(pair.getKey())) {
                valueObject = pair.getValue();
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + pair.getKey() + "' (supported attributes: '" + valueKey + "') in " + expectedType);
        }
        if (valueObject == null) {
            throw new JSONParserException("Missing attribute '" + valueKey + "' in " + expectedType);
        }
        String value = ResourceConfigurationParser.asString(valueObject, valueKey);
        registry.accept(value);
    }
}

