/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jni.JNIRuntimeAccess;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="java")
class WindowsJavaIOSubstituteFeature
implements Feature {
    WindowsJavaIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.io.RandomAccessFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.ZipFile"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Inflater"), "required for substitutions");
        ((RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class)).rerunInitialization(access.findClassByName("java.util.zip.Deflater"), "required for substitutions");
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(String.class);
            JNIRuntimeAccess.register(access.findClassByName("java.io.WinNTFileSystem"));
            JNIRuntimeAccess.register(IOException.class.getDeclaredConstructor(String.class));
            JNIRuntimeAccess.register(File.class.getDeclaredField("path"));
            JNIRuntimeAccess.register(FileOutputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileInputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("handle"));
            JNIRuntimeAccess.register(RandomAccessFile.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("needDict"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("finished"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("buf"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("off"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("len"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("level"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("strategy"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("setParams"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("finish"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("finished"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("buf"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("off"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("len"));
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            VMError.shouldNotReachHere("WindowsJavaIOSubstitutionFeature: Error registering class or method: ", e);
        }
    }
}

