/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Util_java_io_FileInputStream;
import com.oracle.svm.core.posix.headers.Fcntl;
import com.oracle.svm.core.posix.headers.Ioctl;
import com.oracle.svm.core.posix.headers.Stat;
import com.oracle.svm.core.posix.headers.Unistd;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.WordFactory;

@TargetClass(value=FileInputStream.class)
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_io_FileInputStream {
    @Alias
    private FileDescriptor fd;

    Target_java_io_FileInputStream() {
    }

    @Substitute
    private int readBytes(byte[] b, int off, int len) throws IOException {
        return PosixUtils.readBytes(b, off, len, this.fd);
    }

    @Substitute
    private void open(String name) throws FileNotFoundException {
        PosixUtils.fileOpen(name, this.fd, Fcntl.O_RDONLY());
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private void close0() throws IOException {
        PosixUtils.fileClose(this.fd);
    }

    @Substitute
    public int read() throws IOException {
        return PosixUtils.readSingle(this.fd);
    }

    @Substitute
    public int available() throws IOException {
        int mode;
        int handle = PosixUtils.getFDHandle(this.fd);
        SignedWord ret = (SignedWord)WordFactory.zero();
        boolean av = false;
        Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
        if (Stat.fstat(handle, stat2) >= 0 && (Util_java_io_FileInputStream.isChr(mode = stat2.st_mode()) || Util_java_io_FileInputStream.isFifo(mode) || Util_java_io_FileInputStream.isSock(mode))) {
            CIntPointer np = (CIntPointer)StackValue.get(CIntPointer.class);
            if (Ioctl.ioctl(handle, Ioctl.FIONREAD(), (PointerBase)np) >= 0) {
                ret = WordFactory.signed((int)np.read());
                av = true;
            }
        }
        if (!av) {
            SignedWord cur = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR());
            if (cur.equal(WordFactory.signed((int)-1))) {
                av = false;
            } else {
                SignedWord end = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_END());
                if (end.equal(WordFactory.signed((int)-1))) {
                    av = false;
                } else if (Unistd.lseek(handle, cur, Unistd.SEEK_SET()).equal(WordFactory.signed((int)-1))) {
                    av = false;
                } else {
                    ret = end.subtract(cur);
                    av = true;
                }
            }
        }
        if (av) {
            long r = ret.rawValue();
            if (r > Integer.MAX_VALUE) {
                r = Integer.MAX_VALUE;
            }
            return (int)r;
        }
        throw PosixUtils.newIOExceptionWithLastError("");
    }

    @Substitute
    public long skip(long n) throws IOException {
        SignedWord cur = (SignedWord)WordFactory.zero();
        SignedWord end = (SignedWord)WordFactory.zero();
        int handle = PosixUtils.getFDHandle(this.fd);
        cur = Unistd.lseek(handle, (SignedWord)WordFactory.zero(), Unistd.SEEK_CUR());
        if (cur.equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek error");
        }
        end = Unistd.lseek(handle, WordFactory.signed((long)n), Unistd.SEEK_CUR());
        if (end.equal(WordFactory.signed((int)-1))) {
            throw PosixUtils.newIOExceptionWithLastError("Seek error");
        }
        return end.subtract(cur).rawValue();
    }
}

