/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.InvokeJavaFunctionPointer;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.hub.DynamicHub;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import sun.misc.Unsafe;

public final class ClassInitializationInfo {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    public static final ClassInitializationInfo INITIALIZED_INFO_SINGLETON = new ClassInitializationInfo();
    private final ClassInitializerFunctionPointerHolder classInitializer;
    private InitState initState;
    private Thread initThread;
    private final ReentrantLock initLock;
    private Condition initCondition;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    private ClassInitializationInfo() {
        this.classInitializer = null;
        this.initState = InitState.FullyInitialized;
        this.initLock = null;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public ClassInitializationInfo(CFunctionPointer classInitializer) {
        this.classInitializer = classInitializer == null || classInitializer.isNull() ? null : new ClassInitializerFunctionPointerHolder(classInitializer);
        this.initState = InitState.Linked;
        this.initLock = new ReentrantLock();
    }

    boolean isInitialized() {
        return this.initState == InitState.FullyInitialized;
    }

    private boolean isBeingInitialized() {
        return this.initState == InitState.BeingInitialized;
    }

    private boolean isInErrorState() {
        return this.initState == InitState.InitializationError;
    }

    private boolean isReentrantInitialization(Thread thread) {
        return thread == this.initThread;
    }

    @NeverInline(value="Class initialization slow path, for example do not inline into Truffle compilations")
    void initialize(DynamicHub hub) {
        Thread self = Thread.currentThread();
        this.initLock.lock();
        try {
            while (this.isBeingInitialized() && !this.isReentrantInitialization(self)) {
                if (this.initCondition == null) {
                    this.initCondition = this.initLock.newCondition();
                }
                this.initCondition.awaitUninterruptibly();
            }
            if (this.isBeingInitialized() && this.isReentrantInitialization(self)) {
                return;
            }
            if (this.isInitialized()) {
                return;
            }
            if (this.isInErrorState()) {
                throw new NoClassDefFoundError("Could not initialize class " + hub.getName());
            }
            this.initState = InitState.BeingInitialized;
            this.initThread = self;
        }
        finally {
            this.initLock.unlock();
        }
        if (!hub.isInterface()) {
            try {
                if (hub.getSuperHub() != null) {
                    hub.getSuperHub().ensureInitialized();
                }
                if (hub.hasDefaultMethods()) {
                    ClassInitializationInfo.initializeSuperInterfaces(hub);
                }
            }
            catch (Throwable ex) {
                this.setInitializationStateAndNotify(InitState.InitializationError);
                throw ex;
            }
        }
        Throwable exception = null;
        try {
            this.invokeClassInitializer();
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (exception != null) {
            if (!(exception instanceof Error)) {
                exception = new ExceptionInInitializerError(exception);
            }
            this.setInitializationStateAndNotify(InitState.InitializationError);
            throw (Error)exception;
        }
        this.setInitializationStateAndNotify(InitState.FullyInitialized);
    }

    private static void initializeSuperInterfaces(DynamicHub hub) {
        assert (hub.hasDefaultMethods()) : "caller should have checked this";
        for (DynamicHub iface : hub.getInterfaces()) {
            if (iface.hasDefaultMethods()) {
                ClassInitializationInfo.initializeSuperInterfaces(iface);
            }
            if (!iface.declaresDefaultMethods()) continue;
            iface.ensureInitialized();
        }
    }

    private void setInitializationStateAndNotify(InitState state) {
        this.initLock.lock();
        try {
            this.initState = state;
            this.initThread = null;
            UNSAFE.storeFence();
            if (this.initCondition != null) {
                this.initCondition.signalAll();
                this.initCondition = null;
            }
        }
        finally {
            this.initLock.unlock();
        }
    }

    private void invokeClassInitializer() {
        if (this.classInitializer != null) {
            ((ClassInitializerFunctionPointer)this.classInitializer.functionPointer).invoke();
        }
    }

    public static class ClassInitializerFunctionPointerHolder {
        final CFunctionPointer functionPointer;

        ClassInitializerFunctionPointerHolder(CFunctionPointer functionPointer) {
            this.functionPointer = functionPointer;
        }
    }

    static interface ClassInitializerFunctionPointer
    extends CFunctionPointer {
        @InvokeJavaFunctionPointer
        public void invoke();
    }

    static enum InitState {
        Linked,
        BeingInitialized,
        FullyInitialized,
        InitializationError;

    }
}

