/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateIntrinsics;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.meta.SharedType;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaTypeProfile;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.calc.UnsignedMath;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.InstanceOfSnippetsTemplates;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.ObjectAccess;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

public final class TypeSnippets
extends SubstrateTemplates
implements Snippets {
    private final RuntimeConfiguration runtimeConfig;
    protected final SnippetTemplate.SnippetInfo instanceOfDynamic = this.snippet(TypeSnippets.class, "instanceOfDynamicSnippet", new LocationIdentity[0]);

    @Snippet
    protected static SubstrateIntrinsics.Any typeEqualityTestSnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, int fromTypeID) {
        Object objectNonNull;
        int typeCheckId;
        if (object != null && (typeCheckId = SubstrateIntrinsics.loadHub(objectNonNull = PiNode.piCastNonNull((Object)object, (GuardingNode)SnippetAnchorNode.anchor())).getTypeID()) == fromTypeID) {
            return trueValue;
        }
        return falseValue;
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfSnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, int fromTypeID, int numTypeIDs) {
        if (object != null) {
            Object objectNonNull = PiNode.piCastNonNull((Object)object, (GuardingNode)SnippetAnchorNode.anchor());
            if (numTypeIDs > 0) {
                int typeCheckId = SubstrateIntrinsics.loadHub(objectNonNull).getTypeID();
                if (numTypeIDs == 1 ? typeCheckId == fromTypeID : UnsignedMath.belowThan((int)(typeCheckId - fromTypeID), (int)numTypeIDs)) {
                    return trueValue;
                }
            }
        }
        return falseValue;
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfBitTestSnippet(Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, int bitsOffset, byte bitMask) {
        if (object == null) {
            return falseValue;
        }
        Object objectNonNull = PiNode.piCastNonNull((Object)object, (GuardingNode)SnippetAnchorNode.anchor());
        if ((ObjectAccess.readByte((Object)SubstrateIntrinsics.loadHub(objectNonNull), (int)bitsOffset) & bitMask) != 0) {
            return trueValue;
        }
        return falseValue;
    }

    @Snippet
    protected static SubstrateIntrinsics.Any instanceOfDynamicSnippet(DynamicHub type, Object object, SubstrateIntrinsics.Any trueValue, SubstrateIntrinsics.Any falseValue, @Snippet.ConstantParameter boolean allowsNull) {
        if (object == null) {
            return allowsNull ? trueValue : falseValue;
        }
        Object objectNonNull = PiNode.piCastNonNull((Object)object, (GuardingNode)SnippetAnchorNode.anchor());
        int[] matches = type.getAssignableFromMatches();
        DynamicHub objectHub = SubstrateIntrinsics.loadHub(objectNonNull);
        int le = DynamicHub.fromClass(matches.getClass()).getLayoutEncoding();
        for (int i = 0; i < matches.length; i += 2) {
            int matchTypeID = ObjectAccess.readInt((Object)matches, (WordBase)LayoutEncoding.getArrayElementOffset(le, i), (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
            int matchLength = ObjectAccess.readInt((Object)matches, (WordBase)LayoutEncoding.getArrayElementOffset(le, i + 1), (LocationIdentity)NamedLocationIdentity.FINAL_LOCATION);
            if (!UnsignedMath.belowThan((int)(objectHub.getTypeID() - matchTypeID), (int)matchLength)) continue;
            return trueValue;
        }
        return falseValue;
    }

    public static void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new TypeSnippets(options, runtimeConfig, factories, providers, snippetReflection, lowerings);
    }

    private TypeSnippets(OptionValues options, RuntimeConfiguration runtimeConfig, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        this.runtimeConfig = runtimeConfig;
        lowerings.put(InstanceOfNode.class, new InstanceOfLowering(options, factories, providers, snippetReflection, ConfigurationValues.getTarget()));
        lowerings.put(InstanceOfDynamicNode.class, new InstanceOfDynamicLowering(options, factories, providers, snippetReflection, ConfigurationValues.getTarget()));
    }

    protected class InstanceOfDynamicLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        public InstanceOfDynamicLowering(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            InstanceOfDynamicNode node = (InstanceOfDynamicNode)replacer.instanceOf;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.instanceOfDynamic, node.graph().getGuardsStage(), tool.getLoweringStage());
            assert (node.isMirror());
            args.add("type", (Object)node.getMirrorOrHub());
            args.add("object", (Object)node.getObject());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.addConst("allowsNull", (Object)node.allowsNull());
            return args;
        }
    }

    protected class InstanceOfLowering
    extends InstanceOfSnippetsTemplates
    implements NodeLoweringProvider<FloatingNode> {
        private final SnippetTemplate.SnippetInfo typeEqualityTest;
        private final SnippetTemplate.SnippetInfo instanceOf;
        private final SnippetTemplate.SnippetInfo instanceOfBitTest;

        public InstanceOfLowering(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, TargetDescription target) {
            super(options, factories, providers, snippetReflection, target);
            this.typeEqualityTest = this.snippet(TypeSnippets.class, "typeEqualityTestSnippet", new LocationIdentity[0]);
            this.instanceOf = this.snippet(TypeSnippets.class, "instanceOfSnippet", new LocationIdentity[0]);
            this.instanceOfBitTest = this.snippet(TypeSnippets.class, "instanceOfBitTestSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(FloatingNode node, LoweringTool tool) {
            InstanceOfNode instanceOfNode = (InstanceOfNode)node;
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                if (instanceOfNode.allowsNull()) {
                    StructuredGraph graph = instanceOfNode.graph();
                    ValueNode object = instanceOfNode.getValue();
                    LogicNode newTypeCheck = (LogicNode)graph.addOrUniqueWithInputs((Node)InstanceOfNode.create((TypeReference)instanceOfNode.type(), (ValueNode)object, (JavaTypeProfile)instanceOfNode.profile(), (AnchoringNode)instanceOfNode.getAnchor()));
                    LogicNode newNode = LogicNode.or((LogicNode)((LogicNode)graph.unique((Node)IsNullNode.create((ValueNode)object))), (LogicNode)newTypeCheck, (double)0.25);
                    instanceOfNode.replaceAndDelete((Node)newNode);
                }
                return;
            }
            VMError.guarantee(!instanceOfNode.allowsNull(), "must be lowered before");
            super.lower(node, tool);
        }

        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            InstanceOfNode node = (InstanceOfNode)replacer.instanceOf;
            TypeReference typeReference = node.type();
            SharedType type = (SharedType)typeReference.getType();
            int fromTypeID = type.getInstanceOfFromTypeID();
            int numTypeIDs = type.getInstanceOfNumTypeIDs();
            VMError.guarantee(!node.allowsNull(), "must be lowered before");
            if (typeReference.isExact()) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.typeEqualityTest, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getValue());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.add("fromTypeID", (Object)type.getHub().getTypeID());
                return args;
            }
            if (fromTypeID == -1) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(TypeSnippets.this.instanceOfDynamic, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("type", (Object)type.getHub());
                args.add("object", (Object)node.getValue());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.addConst("allowsNull", (Object)false);
                return args;
            }
            if (numTypeIDs >= 0) {
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.instanceOf, node.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("object", (Object)node.getValue());
                args.add("trueValue", (Object)replacer.trueValue);
                args.add("falseValue", (Object)replacer.falseValue);
                args.add("fromTypeID", (Object)fromTypeID);
                args.add("numTypeIDs", (Object)numTypeIDs);
                return args;
            }
            assert (numTypeIDs == -1) : "type not expected in type check: " + type + ", " + node;
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.instanceOfBitTest, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("object", (Object)node.getValue());
            args.add("trueValue", (Object)replacer.trueValue);
            args.add("falseValue", (Object)replacer.falseValue);
            args.add("bitsOffset", (Object)TypeSnippets.this.runtimeConfig.getInstanceOfBitOffset(fromTypeID));
            args.add("bitMask", (Object)(1 << fromTypeID % 8));
            return args;
        }
    }
}

