/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.LinkerInvocation;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.util.FileUtils;
import com.oracle.svm.hosted.image.AbstractBootImage;
import com.oracle.svm.hosted.image.CCLinkerInvocation;
import com.oracle.svm.hosted.image.NativeBootImage;
import com.oracle.svm.hosted.image.NativeImageCodeCache;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.impl.InternalPlatform;

public abstract class NativeBootImageViaCC
extends NativeBootImage {
    protected final HostedMethod mainEntryPoint;

    public NativeBootImageViaCC(AbstractBootImage.NativeImageKind k, HostedUniverse universe, HostedMetaAccess metaAccess, NativeLibraries nativeLibs, NativeImageHeap heap, NativeImageCodeCache codeCache, List<HostedMethod> entryPoints, HostedMethod mainEntryPoint, ClassLoader imageClassLoader) {
        super(k, universe, metaAccess, nativeLibs, heap, codeCache, entryPoints, mainEntryPoint, imageClassLoader);
        this.mainEntryPoint = mainEntryPoint;
    }

    public AbstractBootImage.NativeImageKind getOutputKind() {
        return this.kind;
    }

    LinkerInvocation getLinkerInvocation(Path outputDirectory, Path tempDirectory, String imageName) {
        CCLinkerInvocation inv;
        switch (ObjectFile.getNativeFormat()) {
            case MACH_O: {
                inv = new DarwinCCLinkerInvocation();
                break;
            }
            case PECOFF: {
                inv = new WindowsCCLinkerInvocation();
                break;
            }
            default: {
                inv = new BinutilsCCLinkerInvocation();
            }
        }
        Path outputFile = outputDirectory.resolve(imageName + this.getBootImageKind().getFilenameSuffix());
        UserError.guarantee(!Files.isDirectory(outputFile, new LinkOption[0]), "Cannot write image to %s. Path exists as directory. (Use -H:Name=<image name>)", outputFile);
        inv.setOutputFile(outputFile);
        inv.setOutputKind(this.getOutputKind());
        inv.addLibPath(tempDirectory.toString());
        for (String libraryPath : this.nativeLibs.getLibraryPaths()) {
            inv.addLibPath(libraryPath);
        }
        for (String rPath : OptionUtils.flatten(",", SubstrateOptions.LinkerRPath.getValue())) {
            inv.addRPath(rPath);
        }
        for (String library : this.nativeLibs.getLibraries()) {
            inv.addLinkedLibrary(library);
        }
        for (String filename : this.codeCache.getCCInputFiles(tempDirectory, imageName)) {
            inv.addInputFile(filename);
        }
        this.addMainEntryPoint(inv);
        return inv;
    }

    protected void addMainEntryPoint(CCLinkerInvocation inv) {
        if (this.mainEntryPoint != null) {
            inv.addSymbolAlias(this.mainEntryPoint, "main");
        }
    }

    @Override
    public LinkerInvocation write(DebugContext debug, Path outputDirectory, Path tempDirectory, String imageName, FeatureImpl.BeforeImageWriteAccessImpl config) {
        String cmdstr = "";
        String outputstr = "";
        Throwable throwable = null;
        try (Indent indent = debug.logAndIndent("Writing native image");){
            if (OS.getCurrent() == OS.WINDOWS) {
                Path tempFile = tempDirectory.resolve(imageName + ".tmp");
                this.write(tempFile);
                try {
                    Files.copy(tempFile, tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix()), new CopyOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to create Object file " + e);
                }
            } else {
                this.write(tempDirectory.resolve(imageName + ObjectFile.getFilenameSuffix()));
            }
            try {
                LinkerInvocation inv = this.getLinkerInvocation(outputDirectory, tempDirectory, imageName);
                for (Function<LinkerInvocation, LinkerInvocation> fn : config.getLinkerInvocationTransformers()) {
                    inv = fn.apply(inv);
                }
                List<String> cmd = inv.getCommand();
                StringBuilder sb = new StringBuilder("Running command:");
                for (String s : cmd) {
                    sb.append(' ');
                    sb.append(s);
                }
                cmdstr = sb.toString();
                try (DebugContext.Scope s = debug.scope((Object)"InvokeCC");){
                    debug.log("%s", (Object)sb);
                    if (NativeImageOptions.MachODebugInfoTesting.getValue().booleanValue()) {
                        System.out.printf("Testing Mach-O debuginfo generation - SKIP %s%n", cmdstr);
                    } else {
                        ProcessBuilder pb = new ProcessBuilder(new String[0]).command(cmd);
                        pb.directory(tempDirectory.toFile());
                        pb.redirectErrorStream(true);
                        Process p = pb.start();
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        FileUtils.drainInputStream(p.getInputStream(), output);
                        int status = p.waitFor();
                        outputstr = output.toString();
                        debug.log("%s", (Object)output);
                        if (status != 0) {
                            throw new RuntimeException("returned " + status);
                        }
                    }
                }
                LinkerInvocation linkerInvocation = inv;
                return linkerInvocation;
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("host C compiler or linker does not seem to work: " + ex.toString() + "\n\n" + cmdstr + "\n\n" + outputstr);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    class WindowsCCLinkerInvocation
    extends CCLinkerInvocation {
        WindowsCCLinkerInvocation() {
            this.setCompilerCommand("CL");
        }

        @Override
        protected void addOneSymbolAliasOption(List<String> cmd, Map.Entry<ResolvedJavaMethod, String> ent) {
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeBootImageViaCC.this.kind) {
                case EXECUTABLE: 
                case STATIC_EXECUTABLE: {
                    cmd.add("/MD");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("/MD");
                    cmd.add("/LD");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }

        @Override
        public List<String> getCommand() {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.compilerCommand);
            this.setOutputKind(cmd);
            cmd.add("/Zi");
            cmd.add("/Fe" + this.outputFile.toString());
            cmd.addAll(this.inputFilenames);
            cmd.add("/link /INCREMENTAL:NO /NODEFAULTLIB:LIBCMT /NODEFAULTLIB:OLDNAMES");
            for (String libraryPath : NativeBootImageViaCC.this.nativeLibs.getLibraryPaths()) {
                cmd.add("/LIBPATH:" + libraryPath);
            }
            for (String library : NativeBootImageViaCC.this.nativeLibs.getLibraries()) {
                cmd.add(library + ".lib");
            }
            cmd.add("advapi32.lib");
            cmd.add("ws2_32.lib");
            cmd.add("secur32.lib");
            cmd.add("iphlpapi.lib");
            return cmd;
        }
    }

    class DarwinCCLinkerInvocation
    extends CCLinkerInvocation {
        DarwinCCLinkerInvocation() {
        }

        @Override
        protected void addOneSymbolAliasOption(List<String> cmd, Map.Entry<ResolvedJavaMethod, String> ent) {
            cmd.add("-Wl,-alias,_" + NativeBootImage.globalSymbolNameForMethod(ent.getKey()) + ",_" + ent.getValue());
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeBootImageViaCC.this.kind) {
                case STATIC_EXECUTABLE: {
                    throw UserError.abort(OS.getCurrent().name() + " does not support building static executable images.");
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    if (!Platform.includedIn(InternalPlatform.DARWIN_AND_JNI.class)) break;
                    cmd.add("-undefined");
                    cmd.add("dynamic_lookup");
                }
            }
        }
    }

    class BinutilsCCLinkerInvocation
    extends CCLinkerInvocation {
        BinutilsCCLinkerInvocation() {
            this.additionalPreOptions.add("-z");
            this.additionalPreOptions.add("noexecstack");
        }

        @Override
        protected void addOneSymbolAliasOption(List<String> cmd, Map.Entry<ResolvedJavaMethod, String> ent) {
            cmd.add("-Wl,--defsym");
            cmd.add("-Wl," + ent.getValue() + "=" + NativeBootImage.globalSymbolNameForMethod(ent.getKey()));
        }

        @Override
        protected void setOutputKind(List<String> cmd) {
            switch (NativeBootImageViaCC.this.kind) {
                case EXECUTABLE: {
                    break;
                }
                case STATIC_EXECUTABLE: {
                    cmd.add("-static");
                    break;
                }
                case SHARED_LIBRARY: {
                    cmd.add("-shared");
                    break;
                }
                default: {
                    VMError.shouldNotReachHere();
                }
            }
        }
    }
}

