/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.Util_sun_util_locale_provider_LocaleProviderAdapter;
import com.oracle.svm.core.util.VMError;
import java.util.Locale;
import java.util.spi.LocaleServiceProvider;
import sun.util.locale.provider.LocaleProviderAdapter;

@TargetClass(value=LocaleProviderAdapter.class, onlyWith={JDK8OrEarlier.class})
public final class Target_sun_util_locale_provider_LocaleProviderAdapter_JDK8OrEarlier {
    @Alias
    private static LocaleProviderAdapter jreLocaleProviderAdapter;

    @Substitute
    public static LocaleProviderAdapter getAdapter(Class<? extends LocaleServiceProvider> providerClass, Locale locale) {
        LocaleProviderAdapter result = Util_sun_util_locale_provider_LocaleProviderAdapter.cachedAdaptersByClass.get(providerClass);
        if (result == null) {
            throw VMError.unsupportedFeature("LocaleServiceProviderAdapter.getAdapter " + providerClass.getName());
        }
        return result;
    }

    @Substitute
    public static LocaleProviderAdapter forType(LocaleProviderAdapter.Type type) {
        if (type == LocaleProviderAdapter.Type.JRE) {
            return jreLocaleProviderAdapter;
        }
        throw VMError.unsupportedFeature("LocaleProviderAdapter.forType: " + (Object)((Object)type));
    }
}

