/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.KeepOriginal;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.heap.FeebleReferenceList;
import com.oracle.svm.core.jdk.ComputeReferenceValue;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.jdk.ReferenceWrapper;
import com.oracle.svm.core.jdk.Target_java_lang_ref_ReferenceQueue;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.Reference;
import org.graalvm.compiler.api.directives.GraalDirectives;

@TargetClass(value=Reference.class)
@Substitute
final class Target_java_lang_ref_Reference {
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    protected final ReferenceWrapper feeble;
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=ComputeReferenceValue.class)
    protected final Object bootImageStrongValue;

    @Substitute
    protected Target_java_lang_ref_Reference(Object referent) {
        this(referent, null);
    }

    @Substitute
    protected Target_java_lang_ref_Reference(Object referent, Target_java_lang_ref_ReferenceQueue queue) {
        this.feeble = new ReferenceWrapper(referent, queue == null ? null : queue.feeble, this);
        this.bootImageStrongValue = null;
    }

    @Substitute
    public Object get() {
        if (this.feeble != null) {
            return this.feeble.get();
        }
        return this.bootImageStrongValue;
    }

    @Substitute
    public void clear() {
        if (this.feeble != null) {
            this.feeble.clear();
        }
    }

    @Substitute
    public boolean enqueue() {
        FeebleReferenceList frList;
        if (this.feeble != null && (frList = this.feeble.getList()) != null) {
            return frList.push(this.feeble);
        }
        return false;
    }

    @Substitute
    public boolean isEnqueued() {
        if (this.feeble != null) {
            return this.feeble.isEnlisted();
        }
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private static boolean tryHandlePending(boolean waitForNotify) {
        throw VMError.unimplemented();
    }

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    private static boolean waitForReferenceProcessing() {
        throw VMError.unimplemented();
    }

    @KeepOriginal
    @TargetElement(onlyWith={JDK9OrLater.class})
    protected native Object clone() throws CloneNotSupportedException;

    @Substitute
    @TargetElement(onlyWith={JDK9OrLater.class})
    public static void reachabilityFence(Object ref) {
        GraalDirectives.blackhole((Object)ref);
    }
}

