/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Target_java_lang_ClassLoaderHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class NativeLibrarySupport {
    private final ReentrantLock lock = new ReentrantLock();
    private final List<PlatformNativeLibrarySupport.NativeLibrary> loadedLibraries = new ArrayList<PlatformNativeLibrarySupport.NativeLibrary>();
    private final Deque<PlatformNativeLibrarySupport.NativeLibrary> currentLoadContext = new ArrayDeque<PlatformNativeLibrarySupport.NativeLibrary>();
    private String[] paths;
    private LibraryInitializer libraryInitializer;

    static void initialize() {
        ImageSingletons.add(NativeLibrarySupport.class, (Object)new NativeLibrarySupport());
    }

    public static NativeLibrarySupport singleton() {
        return (NativeLibrarySupport)ImageSingletons.lookup(NativeLibrarySupport.class);
    }

    private NativeLibrarySupport() {
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void registerLibraryInitializer(LibraryInitializer initializer) {
        assert (this.libraryInitializer == null);
        this.libraryInitializer = initializer;
    }

    public void loadLibrary(String name, boolean isAbsolute) {
        if (this.paths == null) {
            String[] tokens = SubstrateUtil.split(System.getProperty("java.library.path", ""), File.pathSeparator);
            this.paths = (String[])Arrays.stream(tokens).map(t -> t.isEmpty() ? "." : t).toArray(String[]::new);
        }
        if (isAbsolute) {
            if (this.loadLibrary0(new File(name), false)) {
                return;
            }
            throw new UnsatisfiedLinkError("Can't load library: " + name);
        }
        if (this.loadLibrary0(new File(name), true)) {
            return;
        }
        String libname = System.mapLibraryName(name);
        for (String path : this.paths) {
            File libpath = new File(path, libname);
            if (this.loadLibrary0(libpath, false)) {
                return;
            }
            File altpath = Target_java_lang_ClassLoaderHelper.mapAlternativeName(libpath);
            if (altpath == null || !this.loadLibrary0(libpath, false)) continue;
            return;
        }
        throw new UnsatisfiedLinkError("no " + name + " in java.library.path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadLibrary0(File file, boolean asBuiltin) {
        String canonical;
        if (asBuiltin && (this.libraryInitializer == null || !this.libraryInitializer.isBuiltinLibrary(file.getName()))) {
            return false;
        }
        try {
            canonical = asBuiltin ? file.getName() : file.getCanonicalPath();
        }
        catch (IOException e) {
            return false;
        }
        this.lock.lock();
        try {
            for (PlatformNativeLibrarySupport.NativeLibrary loaded : this.loadedLibraries) {
                if (!canonical.equals(loaded.getCanonicalIdentifier())) continue;
                boolean bl = true;
                return bl;
            }
            for (PlatformNativeLibrarySupport.NativeLibrary loading : this.currentLoadContext) {
                if (!canonical.equals(loading.getCanonicalIdentifier())) continue;
                boolean bl = true;
                return bl;
            }
            PlatformNativeLibrarySupport.NativeLibrary lib = PlatformNativeLibrarySupport.singleton().createLibrary(canonical, asBuiltin);
            this.currentLoadContext.push(lib);
            try {
                if (!lib.load()) {
                    boolean loading = false;
                    return loading;
                }
                if (this.libraryInitializer != null) {
                    this.libraryInitializer.initialize(lib);
                }
            }
            finally {
                PlatformNativeLibrarySupport.NativeLibrary top = this.currentLoadContext.pop();
                assert (top == lib);
            }
            this.loadedLibraries.add(lib);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointerBase findSymbol(String name) {
        this.lock.lock();
        try {
            for (PlatformNativeLibrarySupport.NativeLibrary lib : this.loadedLibraries) {
                PointerBase entry = lib.findSymbol(name);
                if (!entry.isNonNull()) continue;
                PointerBase pointerBase = entry;
                return pointerBase;
            }
            PointerBase pointerBase = WordFactory.nullPointer();
            return pointerBase;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static interface LibraryInitializer {
        public boolean isBuiltinLibrary(String var1);

        public void initialize(PlatformNativeLibrarySupport.NativeLibrary var1);
    }
}

