/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Field;
import java.util.concurrent.Exchanger;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ExchangerABASEComputer
implements RecomputeFieldValue.CustomFieldValueComputer {
    ExchangerABASEComputer() {
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        try {
            ObjectLayout layout = (ObjectLayout)ImageSingletons.lookup(ObjectLayout.class);
            Field ashiftField = Exchanger.class.getDeclaredField("ASHIFT");
            ashiftField.setAccessible(true);
            int ashift = ashiftField.getInt(null);
            JavaKind ak = JavaKind.Object;
            int abase = layout.getArrayBaseOffset(ak) + (1 << ashift);
            int s = layout.getArrayIndexScale(ak);
            if ((s & s - 1) != 0 || s > 1 << ashift) {
                throw VMError.shouldNotReachHere("Unsupported array scale");
            }
            return abase;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

