/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.hub;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.hub.Util_sun_reflect_generics_reflectiveObjects_WildcardTypeImpl;
import com.oracle.svm.core.hub.WildcardTypeImplLowerBoundsComputer;
import com.oracle.svm.core.hub.WildcardTypeImplUpperBoundsComputer;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.jdk.JDK9OrLater;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Type;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.WildcardTypeImpl;
import sun.reflect.generics.tree.FieldTypeSignature;

@TargetClass(value=WildcardTypeImpl.class)
final class Target_sun_reflect_generics_reflectiveObjects_WildcardTypeImpl {
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=WildcardTypeImplUpperBoundsComputer.class)
    @TargetElement(name="upperBounds", onlyWith={JDK8OrEarlier.class})
    private Type[] upperBoundsJDK8OrEarlier;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=WildcardTypeImplUpperBoundsComputer.class)
    @TargetElement(name="upperBounds", onlyWith={JDK9OrLater.class})
    private Object[] upperBoundsJDK9OrLater;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=WildcardTypeImplLowerBoundsComputer.class)
    @TargetElement(name="lowerBounds", onlyWith={JDK8OrEarlier.class})
    private Type[] lowerBoundsJDK8OrEarlier;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Custom, declClass=WildcardTypeImplLowerBoundsComputer.class)
    @TargetElement(name="lowerBounds", onlyWith={JDK9OrLater.class})
    private Object[] lowerBoundsJDK9OrLater;
    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private FieldTypeSignature[] upperBoundASTs;
    @Delete
    @TargetElement(onlyWith={JDK8OrEarlier.class})
    private FieldTypeSignature[] lowerBoundASTs;

    @Substitute
    private Target_sun_reflect_generics_reflectiveObjects_WildcardTypeImpl(FieldTypeSignature[] ubs, FieldTypeSignature[] lbs, GenericsFactory f) {
        throw VMError.shouldNotReachHere("sun.reflect.generics.reflectiveObjects.WildcardTypeImpl constructor was removed.All the WildcardTypeImpl objects should be allocated at image build time and cached in the native image heap.");
    }

    @Substitute
    public Type[] getUpperBounds() {
        if (JavaVersionUtil.Java8OrEarlier) {
            return this.upperBoundsJDK8OrEarlier;
        }
        Object[] value = this.upperBoundsJDK9OrLater;
        if (value instanceof FieldTypeSignature[]) {
            this.upperBoundsJDK9OrLater = value = Util_sun_reflect_generics_reflectiveObjects_WildcardTypeImpl.reifyBounds(this, (FieldTypeSignature[])value);
        }
        return (Type[])value.clone();
    }

    @Substitute
    public Type[] getLowerBounds() {
        if (JavaVersionUtil.Java8OrEarlier) {
            return this.lowerBoundsJDK8OrEarlier;
        }
        Object[] value = this.lowerBoundsJDK9OrLater;
        if (value instanceof FieldTypeSignature[]) {
            this.lowerBoundsJDK9OrLater = value = Util_sun_reflect_generics_reflectiveObjects_WildcardTypeImpl.reifyBounds(this, (FieldTypeSignature[])value);
        }
        return (Type[])value.clone();
    }
}

