/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.util.VMError;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.graalvm.nativeimage.PinnedObject;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

public final class PinnedBuffer
implements AutoCloseable {
    private final Buffer buffer;
    private final PinnedObject arrayPin;
    private final int shift;
    private boolean open;

    public static PinnedBuffer open(Buffer buffer) {
        return new PinnedBuffer(buffer);
    }

    private PinnedBuffer(Buffer buffer) {
        this.buffer = buffer;
        if (buffer == null || buffer.isDirect()) {
            this.arrayPin = null;
        } else if (buffer.hasArray()) {
            this.arrayPin = PinnedObject.create((Object)buffer.array());
        } else {
            throw VMError.shouldNotReachHere("cannot pin non-direct non-array Buffer");
        }
        if (buffer == null || buffer instanceof ByteBuffer) {
            this.shift = 0;
        } else if (buffer instanceof CharBuffer || buffer instanceof ShortBuffer) {
            this.shift = 1;
        } else if (buffer instanceof IntBuffer || buffer instanceof FloatBuffer) {
            this.shift = 2;
        } else if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
            this.shift = 3;
        } else {
            throw VMError.shouldNotReachHere("Unknown Buffer type");
        }
        this.open = true;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public boolean isOpen() {
        return this.open;
    }

    public <T extends PointerBase> T addressOf(int position) {
        assert (this.open);
        if (this.arrayPin != null) {
            return (T)this.arrayPin.addressOfArrayElement(this.buffer.arrayOffset() + position);
        }
        if (this.buffer == null) {
            return (T)WordFactory.nullPointer();
        }
        long address = KnownIntrinsics.unsafeCast((Object)this.buffer, Target_java_nio_Buffer.class).address;
        return (T)WordFactory.pointer((long)(address + (long)(position << this.shift)));
    }

    @Override
    public void close() {
        assert (this.open);
        this.open = false;
        if (this.arrayPin != null) {
            this.arrayPin.close();
        }
    }

    @TargetClass(className="java.nio.Buffer")
    static final class Target_java_nio_Buffer {
        @Alias
        long address;

        Target_java_nio_Buffer() {
        }
    }
}

