/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.thread.Safepoint;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

final class SafepointSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    private static void safepointSnippet() {
        Safepoint.checkSafepointRequested();
    }

    private SafepointSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(SafepointNode.class, new SafepointLowering());
    }

    @AutomaticFeature
    static class SafepointFeature
    implements GraalFeature {
        SafepointFeature() {
        }

        @Override
        public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls, boolean hosted) {
            for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : Safepoint.FOREIGN_CALLS) {
                foreignCalls.put(descriptor, new SubstrateForeignCallLinkage(providers, descriptor));
            }
        }

        @Override
        public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
            new SafepointSnippets(options, factories, providers, snippetReflection, lowerings);
        }
    }

    class SafepointLowering
    implements NodeLoweringProvider<SafepointNode> {
        private final SnippetTemplate.SnippetInfo safepoint;

        SafepointLowering() {
            this.safepoint = SafepointSnippets.this.snippet(SafepointSnippets.class, "safepointSnippet", new LocationIdentity[]{Safepoint.getThreadLocalSafepointRequestedLocationIdentity()});
        }

        @Override
        public void lower(SafepointNode node, LoweringTool tool) {
            assert (SubstrateOptions.MultiThreaded.getValue().booleanValue()) : "safepoints are only inserted into the graph in MultiThreaded mode";
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.safepoint, node.graph().getGuardsStage(), tool.getLoweringStage());
            SafepointSnippets.this.template((ValueNode)node, args).instantiate(SafepointSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

