/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapImpl;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.RuntimeOptionKey;
import com.oracle.svm.core.util.TimeUtils;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public abstract class CollectionPolicy {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    static CollectionPolicy getInitialPolicy(Feature.FeatureAccess access) {
        return HeapPolicy.instantiatePolicy(access, CollectionPolicy.class, Options.InitialCollectionPolicy.getValue());
    }

    public abstract boolean collectIncrementally();

    public abstract boolean collectCompletely();

    CollectionPolicy() {
    }

    public abstract void nameToLog(Log var1);

    protected static GCImpl.Accounting getAccounting() {
        return HeapImpl.getHeapImpl().getGCImpl().getAccounting();
    }

    public static class BySpaceAndTime
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return true;
        }

        @Override
        public boolean collectCompletely() {
            Log trace = Log.noopLog().string("[CollectionPolicy.BySpaceAndTime.collectCompletely:").newline();
            boolean result = BySpaceAndTime.decideToCollectCompletely(trace);
            trace.string("  returns: ").bool(result).string("]").newline();
            return result;
        }

        @Override
        public void nameToLog(Log log) {
            log.string("by space and time: ").signed(Options.PercentTimeInIncrementalCollection.getValue()).string("% in incremental collections");
        }

        private static boolean decideToCollectCompletely(Log trace) {
            if (BySpaceAndTime.voteOnMaximumSpace(trace)) {
                return true;
            }
            if (BySpaceAndTime.vetoOnMinimumSpace(trace)) {
                return false;
            }
            return !BySpaceAndTime.vetoOnIncrementalTime(trace);
        }

        private static boolean voteOnMaximumSpace(Log trace) {
            UnsignedWord youngSize = HeapPolicy.getMaximumYoungGenerationSize();
            UnsignedWord oldInUse = BySpaceAndTime.getAccounting().getOldGenerationAfterChunkBytes();
            UnsignedWord averagePromotion = BySpaceAndTime.getAccounting().averagePromotedUnpinnedChunkBytes().add(BySpaceAndTime.getAccounting().averagePromotedPinnedChunkBytes());
            UnsignedWord expectedSize = youngSize.add(oldInUse).add(averagePromotion);
            UnsignedWord maxHeapSize = HeapPolicy.getMaximumHeapSize();
            boolean vote = maxHeapSize.belowThan(expectedSize);
            trace.string("  youngSize: ").unsigned((WordBase)youngSize).string("  oldInUse: ").unsigned((WordBase)oldInUse).string("  averagePromotedUnpinnedChunkBytes: ").unsigned((WordBase)BySpaceAndTime.getAccounting().averagePromotedUnpinnedChunkBytes()).string("  averagePromotedPinnedChunkBytes: ").unsigned((WordBase)BySpaceAndTime.getAccounting().averagePromotedPinnedChunkBytes()).string("  averagePromotion: ").unsigned((WordBase)averagePromotion).string("  expectedSize: ").unsigned((WordBase)expectedSize).string("  maxHeapSize: ").unsigned((WordBase)maxHeapSize).string("  vote: ").bool(vote).newline();
            return vote;
        }

        private static boolean vetoOnMinimumSpace(Log trace) {
            UnsignedWord youngSize = HeapPolicy.getMaximumYoungGenerationSize();
            UnsignedWord oldInUse = BySpaceAndTime.getAccounting().getOldGenerationAfterChunkBytes();
            UnsignedWord heapInUse = youngSize.add(oldInUse);
            UnsignedWord minHeapSize = HeapPolicy.getMinimumHeapSize();
            boolean veto = heapInUse.belowThan(minHeapSize);
            trace.string("  oldInUse: ").unsigned((WordBase)oldInUse).string("  heapInUse: ").unsigned((WordBase)heapInUse).string("  minHeapSize: ").unsigned((WordBase)minHeapSize).string("  veto: ").bool(veto).newline();
            return veto;
        }

        private static boolean vetoOnIncrementalTime(Log trace) {
            int incrementalWeight = Options.PercentTimeInIncrementalCollection.getValue();
            assert (0L <= (long)incrementalWeight && (long)incrementalWeight <= 100L) : "BySpaceAndTimePercentTimeInIncrementalCollection should be in the range [0..100].";
            long incrementalNanos = BySpaceAndTime.getAccounting().getIncrementalCollectionTotalNanos();
            long completeNanos = BySpaceAndTime.getAccounting().getCompleteCollectionTotalNanos();
            long totalNanos = incrementalNanos + completeNanos;
            long weightedTotalNanos = TimeUtils.weightedNanos(incrementalWeight, totalNanos);
            boolean veto = TimeUtils.nanoTimeLessThan(incrementalNanos, weightedTotalNanos);
            trace.string("  incrementalWeight: ").signed(incrementalWeight).string("  incrementalNanos: ").unsigned(incrementalNanos).string("  completeNanos: ").unsigned(completeNanos).string("  totalNanos: ").unsigned(totalNanos).string("  weightedTotalNanos: ").unsigned(weightedTotalNanos).string("  veto: ").bool(veto).newline();
            return veto;
        }
    }

    public static class ByTime
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return true;
        }

        @Override
        public boolean collectCompletely() {
            Log trace = Log.noopLog().string("[CollectionPolicy.ByTime.collectIncrementally:");
            boolean result = ByTime.collectCompletelyBasedOnTime(trace) || ByTime.collectCompletelyBasedOnSpace(trace);
            trace.string("  returns: ").bool(result).string("]").newline();
            return result;
        }

        @Override
        public void nameToLog(Log log) {
            log.string("by time: ").signed(Options.PercentTimeInIncrementalCollection.getValue()).string("% in incremental collections");
        }

        private static boolean collectCompletelyBasedOnTime(Log trace) {
            int incrementalWeight = Options.PercentTimeInIncrementalCollection.getValue();
            trace.string("  incrementalWeight: ").signed(incrementalWeight).newline();
            assert (0L <= (long)incrementalWeight && (long)incrementalWeight <= 100L) : "ByTimePercentTimeInIncrementalCollection should be in the range [0..100].";
            long incrementalNanos = ByTime.getAccounting().getIncrementalCollectionTotalNanos();
            long completeNanos = ByTime.getAccounting().getCompleteCollectionTotalNanos();
            long totalNanos = incrementalNanos + completeNanos;
            long weightedTotalNanos = TimeUtils.weightedNanos(incrementalWeight, totalNanos);
            trace.string("  incrementalNanos: ").unsigned(incrementalNanos).string("  completeNanos: ").unsigned(completeNanos).string("  totalNanos: ").unsigned(totalNanos).string("  weightedTotalNanos: ").unsigned(weightedTotalNanos).newline();
            return TimeUtils.nanoTimeLessThan(weightedTotalNanos, incrementalNanos);
        }

        private static boolean collectCompletelyBasedOnSpace(Log trace) {
            UnsignedWord heapSize = HeapPolicy.getMaximumHeapSize();
            UnsignedWord youngSize = HeapPolicy.getMaximumYoungGenerationSize();
            UnsignedWord oldInUse = ByTime.getAccounting().getOldGenerationAfterChunkBytes();
            UnsignedWord withFullPromotion = youngSize.add(oldInUse).add(youngSize);
            trace.string("  withFullPromotion: ").unsigned((WordBase)withFullPromotion).newline();
            return heapSize.belowThan(withFullPromotion);
        }
    }

    public static class NeverCollect
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return false;
        }

        @Override
        public boolean collectCompletely() {
            return false;
        }

        @Override
        public void nameToLog(Log log) {
            log.string("never collect");
        }
    }

    public static class OnlyCompletely
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return false;
        }

        @Override
        public boolean collectCompletely() {
            return true;
        }

        @Override
        public void nameToLog(Log log) {
            log.string("only completely");
        }
    }

    public static class OnlyIncrementally
    extends CollectionPolicy {
        @Override
        public boolean collectIncrementally() {
            return true;
        }

        @Override
        public boolean collectCompletely() {
            return false;
        }

        @Override
        public void nameToLog(Log log) {
            log.string("only incrementally");
        }
    }

    public static class Options {
        @Option(help={"What is the initial collection policy?"})
        public static final HostedOptionKey<String> InitialCollectionPolicy = new HostedOptionKey<String>(ByTime.class.getName());
        @Option(help={"Percentage of time that should be spent in young generation collections."})
        public static final RuntimeOptionKey<Integer> PercentTimeInIncrementalCollection = new RuntimeOptionKey<Integer>(50);
    }
}

