/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.CPUFeatureAccess;
import com.oracle.svm.core.CompilerCommandPlugin;
import com.oracle.svm.core.MemoryUtil;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.jdk.RuntimeFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionParser;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.VMError;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CCharPointerPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class JavaMainWrapper {
    private static int argc;
    private static CCharPointerPointer argv;
    private static UnsignedWord argvLength;
    private static String[] mainArgs;
    private static final Thread preallocatedThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CEntryPoint
    @CEntryPointOptions(prologue=CEntryPointSetup.EnterCreateIsolatePrologue.class, include=CEntryPointOptions.NotIncludedAutomatically.class)
    public static int run(int paramArgc, CCharPointerPointer paramArgv) throws Exception {
        int exitCode;
        JavaThreads.singleton().assignJavaThread(preallocatedThread, true);
        argc = paramArgc;
        argv = paramArgv;
        Architecture imageArchitecture = ((SubstrateTargetDescription)((Object)ImageSingletons.lookup(SubstrateTargetDescription.class))).arch;
        CPUFeatureAccess cpuFeatureAccess = (CPUFeatureAccess)ImageSingletons.lookup(CPUFeatureAccess.class);
        cpuFeatureAccess.verifyHostSupportsArchitecture(imageArchitecture);
        String[] args = SubstrateUtil.getArgs(paramArgc, paramArgv);
        args = RuntimeOptionParser.parseAndConsumeAllOptions(args);
        mainArgs = args;
        try {
            if (SubstrateOptions.ParseRuntimeOptions.getValue().booleanValue()) {
                RuntimeSupport.getRuntimeSupport().executeStartupHooks();
            }
            ((JavaMainSupport)ImageSingletons.lookup(JavaMainSupport.class)).javaMainHandle.invokeExact(args);
            exitCode = 0;
        }
        catch (Throwable ex) {
            JavaThreads.dispatchUncaughtException(Thread.currentThread(), ex);
            exitCode = 1;
        }
        finally {
            JavaThreads.singleton().joinAllNonDaemons();
            RuntimeSupport.getRuntimeSupport().shutdown();
            Counter.logValues();
        }
        return exitCode;
    }

    public static long getCRuntimeArgumentBlockLength() {
        VMError.guarantee(argv.notEqual((ComparableWord)WordFactory.zero()) && argc > 0, "Requires JavaMainWrapper.run(int, CCharPointerPointer) entry point!");
        CCharPointer firstArgPos = argv.read(0);
        if (argvLength.equal((UnsignedWord)WordFactory.zero())) {
            CCharPointer lastArgPos = argv.read(argc - 1);
            UnsignedWord lastArgLength = SubstrateUtil.strlen(lastArgPos);
            argvLength = WordFactory.unsigned((long)lastArgPos.rawValue()).add(lastArgLength).subtract(WordFactory.unsigned((long)firstArgPos.rawValue()));
        }
        return argvLength.rawValue();
    }

    public static boolean setCRuntimeArgument0(String arg0) {
        boolean arg0truncation = false;
        try (CTypeConversion.CCharPointerHolder arg0Pin = CTypeConversion.toCString((CharSequence)arg0);){
            UnsignedWord origLength;
            CCharPointer arg0Pointer = arg0Pin.get();
            UnsignedWord arg0Length = SubstrateUtil.strlen(arg0Pointer);
            UnsignedWord newArgLength = origLength = WordFactory.unsigned((long)JavaMainWrapper.getCRuntimeArgumentBlockLength());
            if (arg0Length.add(1).belowThan(origLength)) {
                newArgLength = arg0Length.add(1);
            }
            arg0truncation = arg0Length.aboveThan(origLength);
            CCharPointer firstArgPos = argv.read(0);
            MemoryUtil.copyConjointMemoryAtomic((Pointer)WordFactory.pointer((long)arg0Pointer.rawValue()), (Pointer)WordFactory.pointer((long)firstArgPos.rawValue()), newArgLength);
            MemoryUtil.fillToMemoryAtomic((Pointer)WordFactory.unsigned((long)firstArgPos.rawValue()).add(newArgLength), origLength.subtract(newArgLength), (byte)0);
        }
        return arg0truncation;
    }

    static {
        Word.ensureInitialized();
        argvLength = (UnsignedWord)WordFactory.zero();
        preallocatedThread = new Thread("main");
        preallocatedThread.setDaemon(false);
    }

    private static class SetCRuntimeArgument0Command
    implements CompilerCommandPlugin {
        private SetCRuntimeArgument0Command() {
        }

        @Override
        public String name() {
            return "com.oracle.svm.core.JavaMainWrapper.setCRuntimeArgument0(String)boolean";
        }

        @Override
        public Object apply(Object[] args) {
            return JavaMainWrapper.setCRuntimeArgument0((String)args[0]);
        }
    }

    private static class GetCRuntimeArgumentBlockLengthCommand
    implements CompilerCommandPlugin {
        private GetCRuntimeArgumentBlockLengthCommand() {
        }

        @Override
        public String name() {
            return "com.oracle.svm.core.JavaMainWrapper.getCRuntimeArgumentBlockLength()long";
        }

        @Override
        public Object apply(Object[] args) {
            return JavaMainWrapper.getCRuntimeArgumentBlockLength();
        }
    }

    @AutomaticFeature
    public static class ExposeCRuntimeArgumentBlockFeature
    implements Feature {
        public List<Class<? extends Feature>> getRequiredFeatures() {
            return Arrays.asList(RuntimeFeature.class);
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            RuntimeSupport rs = RuntimeSupport.getRuntimeSupport();
            rs.addCommandPlugin(new GetCRuntimeArgumentBlockLengthCommand());
            rs.addCommandPlugin(new SetCRuntimeArgument0Command());
        }
    }

    public static class JavaMainSupport {
        final MethodHandle javaMainHandle;
        final String javaMainClassName;

        @Platforms(value={Platform.HOSTED_ONLY.class})
        public JavaMainSupport(Method javaMainMethod) throws IllegalAccessException {
            this.javaMainHandle = MethodHandles.lookup().unreflect(javaMainMethod);
            this.javaMainClassName = javaMainMethod.getDeclaringClass().getName();
        }

        public String getJavaCommand() {
            if (mainArgs != null) {
                StringBuilder commandLine = new StringBuilder(this.javaMainClassName);
                for (String arg : mainArgs) {
                    commandLine.append(' ');
                    commandLine.append(arg);
                }
                return commandLine.toString();
            }
            return null;
        }

        public List<String> getInputArguments() {
            if (argv.isNonNull() && argc > 0) {
                String[] unmodifiedArgs = SubstrateUtil.getArgs(argc, argv);
                ArrayList<String> inputArgs = new ArrayList<String>(Arrays.asList(unmodifiedArgs));
                if (mainArgs != null) {
                    inputArgs.removeAll(Arrays.asList(mainArgs));
                }
                return Collections.unmodifiableList(inputArgs);
            }
            return Collections.emptyList();
        }
    }
}

