/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.nfi;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.truffle.nfi.LibFFI;
import com.oracle.svm.truffle.nfi.LocalNativeScope;
import com.oracle.svm.truffle.nfi.NativeAPI;
import com.oracle.svm.truffle.nfi.NativeClosure;
import com.oracle.svm.truffle.nfi.Target_com_oracle_truffle_nfi_impl_NFIContext;
import com.oracle.svm.truffle.nfi.TruffleObjectHandle;
import com.oracle.truffle.api.CompilerDirectives;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.graalvm.nativeimage.ObjectHandle;
import org.graalvm.nativeimage.ObjectHandles;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class TruffleNFISupport {
    static final Charset UTF8 = Charset.forName("utf8");
    private static final FastThreadLocalObject<LocalNativeScope> currentScope = FastThreadLocalFactory.createObject(LocalNativeScope.class);
    private final ObjectHandles globalHandles = ObjectHandles.create();
    private final ObjectHandles closureHandles = ObjectHandles.create();
    private final ObjectHandles contextHandles = ObjectHandles.create();
    public final String errnoGetterFunctionName;

    TruffleNFISupport() {
        if (Platform.includedIn(Platform.LINUX.class)) {
            this.errnoGetterFunctionName = "__errno_location";
        } else if (Platform.includedIn(Platform.DARWIN.class)) {
            this.errnoGetterFunctionName = "__error";
        } else {
            throw VMError.unsupportedFeature("unsupported platform for TruffleNFIFeature");
        }
    }

    public static LocalNativeScope createLocalScope(int pinCount) {
        LocalNativeScope parent = currentScope.get();
        LocalNativeScope ret = new LocalNativeScope(parent, pinCount);
        currentScope.set(ret);
        return ret;
    }

    public static void closeLocalScope(LocalNativeScope current, LocalNativeScope parent) {
        assert (currentScope.get() == current);
        currentScope.set(parent);
    }

    public static TruffleObjectHandle createLocalHandle(Object obj) {
        return currentScope.get().createLocalHandle(obj);
    }

    public TruffleObjectHandle createGlobalHandle(Object obj) {
        return (TruffleObjectHandle)this.globalHandles.create(obj);
    }

    public void destroyGlobalHandle(TruffleObjectHandle handle) {
        SignedWord word = (SignedWord)handle;
        if (word.greaterThan(0)) {
            this.globalHandles.destroy((ObjectHandle)word);
        }
    }

    public Object resolveHandle(TruffleObjectHandle handle) {
        SignedWord word = (SignedWord)handle;
        if (word.equal(0)) {
            return null;
        }
        if (word.greaterThan(0)) {
            return this.globalHandles.get((ObjectHandle)word);
        }
        return currentScope.get().resolveLocalHandle(handle);
    }

    public LibFFI.NativeClosureHandle createClosureHandle(NativeClosure closure) {
        return (LibFFI.NativeClosureHandle)this.closureHandles.create((Object)closure);
    }

    public NativeClosure resolveClosureHandle(LibFFI.NativeClosureHandle handle) {
        return (NativeClosure)this.closureHandles.get((ObjectHandle)handle);
    }

    public void destroyClosureHandle(LibFFI.NativeClosureHandle handle) {
        this.closureHandles.destroy((ObjectHandle)handle);
    }

    public NativeAPI.TruffleContextHandle createContextHandle(Target_com_oracle_truffle_nfi_impl_NFIContext context) {
        return (NativeAPI.TruffleContextHandle)this.contextHandles.create((Object)context);
    }

    public Target_com_oracle_truffle_nfi_impl_NFIContext resolveContextHandle(NativeAPI.TruffleContextHandle handle) {
        return (Target_com_oracle_truffle_nfi_impl_NFIContext)this.contextHandles.get((ObjectHandle)handle);
    }

    public void destroyContextHandle(NativeAPI.TruffleContextHandle handle) {
        this.contextHandles.destroy((ObjectHandle)handle);
    }

    @CompilerDirectives.TruffleBoundary
    static String utf8ToJavaString(CCharPointer str) {
        if (str.equal((ComparableWord)WordFactory.zero())) {
            return null;
        }
        UnsignedWord len = SubstrateUtil.strlen(str);
        ByteBuffer buffer = CTypeConversion.asByteBuffer((PointerBase)str, (int)((int)len.rawValue()));
        return UTF8.decode(buffer).toString();
    }

    @CompilerDirectives.TruffleBoundary
    static byte[] javaStringToUtf8(String str) {
        CharsetEncoder encoder = UTF8.newEncoder();
        int sizeEstimate = (int)((float)str.length() * encoder.averageBytesPerChar()) + 1;
        ByteBuffer retBuffer = ByteBuffer.allocate(sizeEstimate);
        CharBuffer input = CharBuffer.wrap(str);
        while (input.hasRemaining()) {
            CoderResult result = encoder.encode(input, retBuffer, true);
            if (result.isUnderflow()) {
                result = encoder.flush(retBuffer);
            }
            if (result.isUnderflow()) break;
            if (result.isOverflow()) {
                sizeEstimate = 2 * sizeEstimate + 1;
                ByteBuffer newBuffer = ByteBuffer.allocate(sizeEstimate);
                retBuffer.flip();
                newBuffer.put(retBuffer);
                retBuffer = newBuffer;
                continue;
            }
            try {
                result.throwException();
            }
            catch (CharacterCodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (retBuffer.remaining() == 0) {
            ByteBuffer newBuffer = ByteBuffer.allocate(retBuffer.limit() + 1);
            newBuffer.put(retBuffer);
            retBuffer = newBuffer;
        }
        retBuffer.put((byte)0);
        return retBuffer.array();
    }
}

