/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.meta;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.c.GraalAccess;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.WordBase;

public class HostedSnippetReflectionProvider
extends SubstrateSnippetReflectionProvider {
    private final SVMHost hostVM;

    public HostedSnippetReflectionProvider(SVMHost hostVM) {
        this.hostVM = hostVM;
    }

    @Override
    public JavaConstant forObject(Object object) {
        if (object instanceof WordBase) {
            return JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)((WordBase)object).rawValue());
        }
        return super.forObject(object);
    }

    @Override
    public <T> T asObject(Class<T> type, JavaConstant constant) {
        Object objectValue;
        if ((type == Class.class || type == Object.class) && constant instanceof SubstrateObjectConstant && (objectValue = SubstrateObjectConstant.asObject((Constant)constant)) instanceof DynamicHub) {
            return type.cast(this.interceptClass((DynamicHub)objectValue));
        }
        return super.asObject(type, constant);
    }

    protected Class<?> interceptClass(DynamicHub dynamicHub) {
        AnalysisType type = this.hostVM.lookupType(dynamicHub);
        try {
            return (Class)GraalAccess.getOriginalSnippetReflection().asObject(Class.class, GraalAccess.getOriginalProviders().getConstantReflection().asJavaClass(type.getWrapped()));
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere("Cannot look up Java class for a DynamicHub: " + dynamicHub.getName() + " - is it a substitution type?");
        }
    }
}

