/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.util.UserError;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class JNIRuntimeAccess {
    private JNIRuntimeAccess() {
    }

    public static void register(Class<?> ... classes) {
        JNIRuntimeAccess.getSupport().register(classes);
    }

    public static void register(Executable ... methods) {
        JNIRuntimeAccess.getSupport().register(methods);
    }

    public static void register(Field ... fields) {
        JNIRuntimeAccess.getSupport().register(fields);
    }

    private static JNIRuntimeAccessibilitySupport getSupport() {
        if (!ImageSingletons.contains(JNIRuntimeAccessibilitySupport.class)) {
            throw UserError.abort("Support for JNI is not enabled. The option -H:" + SubstrateOptions.JNI + " must be set.");
        }
        return (JNIRuntimeAccessibilitySupport)ImageSingletons.lookup(JNIRuntimeAccessibilitySupport.class);
    }

    public static interface JNIRuntimeAccessibilitySupport {
        public void register(Class<?> ... var1);

        public void register(Executable ... var1);

        public void register(Field ... var1);
    }
}

