/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.HostedIdentityHashCodeProvider;
import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.StringInternSupport;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.image.HeapHistogram;
import com.oracle.svm.hosted.image.ObjectGroupHistogram;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.image.StringInternFeature;
import com.oracle.svm.hosted.meta.HostedArrayClass;
import com.oracle.svm.hosted.meta.HostedClass;
import com.oracle.svm.hosted.meta.HostedField;
import com.oracle.svm.hosted.meta.HostedInstanceClass;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.word.WordBase;

public final class NativeImageHeap {
    private final HostedUniverse universe;
    private final AnalysisUniverse aUniverse;
    private final HostedMetaAccess metaAccess;
    private final ObjectLayout layout;
    protected final Map<Object, ObjectInfo> objects = new IdentityHashMap<Object, ObjectInfo>();
    private final Set<Object> blacklist = Collections.newSetFromMap(new IdentityHashMap());
    private final Map<HostedClass, HybridLayout<?>> hybridLayouts = new HashMap();
    private final Map<String, String> internedStrings = new HashMap<String, String>();
    private final Phase addObjectsPhase = Phase.factory();
    private final Phase internStringsPhase = Phase.factory();
    private final Deque<AddObjectData> addObjectWorklist = new ArrayDeque<AddObjectData>();
    private final Set<Object> knownImmutableObjects = Collections.newSetFromMap(new IdentityHashMap());
    private final HeapPartition readOnlyPrimitive;
    private final HeapPartition readOnlyReference;
    private final HeapPartition readOnlyRelocatable;
    private long firstRelocatablePointerOffsetInSection = -1L;
    private final HeapPartition writablePrimitive;
    private final HeapPartition writableReference;

    @Fold
    static boolean useHeapBase() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Fold
    static boolean spawnIsolates() {
        return SubstrateOptions.SpawnIsolates.getValue() != false && NativeImageHeap.useHeapBase();
    }

    public void addInitialObjects() {
        this.addObjectsPhase.allow();
        this.internStringsPhase.allow();
        this.addObject(StaticFieldsSupport.getStaticPrimitiveFields(), false, "primitive static fields");
        this.addStaticFields();
    }

    public void addTrailingObjects() {
        this.processAddObjectWorklist();
        HostedField internedStringsField = (HostedField)StringInternFeature.getInternedStringsField((MetaAccessProvider)this.metaAccess);
        boolean usesInternedStrings = internedStringsField.isAccessed();
        if (usesInternedStrings) {
            this.addObject(this.getMetaAccess().lookupJavaType((Class)String[].class).getHub(), false, "internedStrings table");
            this.internStringsPhase.disallow();
            Object[] imageInternedStrings = this.internedStrings.keySet().toArray(new String[0]);
            Arrays.sort(imageInternedStrings);
            ((StringInternSupport)ImageSingletons.lookup(StringInternSupport.class)).setImageInternedStrings((String[])imageInternedStrings);
            this.addObject(imageInternedStrings, true, "internedStrings table");
            this.processAddObjectWorklist();
        } else {
            this.internStringsPhase.disallow();
        }
        this.addObjectsPhase.disallow();
        assert (this.addObjectWorklist.isEmpty());
    }

    void alignRelocatablePartition(long alignment) {
        long relocatablePartitionOffset = this.readOnlyPrimitive.getSize() + this.readOnlyReference.getSize();
        long beforeRelocPadding = NumUtil.roundUp((long)relocatablePartitionOffset, (long)alignment) - relocatablePartitionOffset;
        this.readOnlyPrimitive.incrementSize(beforeRelocPadding);
        long afterRelocPadding = NumUtil.roundUp((long)this.readOnlyRelocatable.getSize(), (long)alignment) - this.readOnlyRelocatable.getSize();
        this.readOnlyRelocatable.incrementSize(afterRelocPadding);
    }

    private static Object readObjectField(HostedField field, JavaConstant receiver) {
        return SubstrateObjectConstant.asObject((Constant)field.readStorageValue(receiver));
    }

    private void addStaticFields() {
        this.addObject(StaticFieldsSupport.getStaticObjectFields(), false, "staticObjectFields");
        this.addObject(StaticFieldsSupport.getStaticPrimitiveFields(), false, "staticPrimitiveFields");
        for (HostedField field : this.getUniverse().getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isWritten() || !field.isAccessed() || field.getType().getStorageKind() != JavaKind.Object) continue;
            this.addObject(NativeImageHeap.readObjectField(field, null), false, field);
        }
    }

    long getReadOnlySectionSize() {
        return this.readOnlyPrimitive.getSize() + this.readOnlyReference.getSize() + this.readOnlyRelocatable.getSize();
    }

    long getReadOnlyRelocatablePartitionOffset() {
        return this.readOnlyRelocatable.offsetInSection();
    }

    long getFirstRelocatablePointerOffsetInSection() {
        assert (this.firstRelocatablePointerOffsetInSection != -1L);
        return this.firstRelocatablePointerOffsetInSection;
    }

    long getReadOnlyRelocatablePartitionSize() {
        return this.readOnlyRelocatable.getSize();
    }

    void setReadOnlySection(String sectionName, long sectionOffset) {
        this.readOnlyPrimitive.setSection(sectionName, sectionOffset);
        this.readOnlyReference.setSection(sectionName, this.readOnlyPrimitive.offsetInSection(this.readOnlyPrimitive.getSize()));
        this.readOnlyRelocatable.setSection(sectionName, this.readOnlyReference.offsetInSection(this.readOnlyReference.getSize()));
    }

    long getWritableSectionSize() {
        return this.writablePrimitive.getSize() + this.writableReference.getSize();
    }

    void setWritableSection(String sectionName, long sectionOffset) {
        this.writablePrimitive.setSection(sectionName, sectionOffset);
        this.writableReference.setSection(sectionName, this.writablePrimitive.offsetInSection(this.writablePrimitive.getSize()));
    }

    public void registerAsImmutable(Object object) {
        assert (this.addObjectsPhase.isBefore()) : "Registering immutable object too late: phase: " + this.addObjectsPhase.toString();
        this.knownImmutableObjects.add(object);
    }

    public void addObject(Object original, boolean immutableFromParent, Object reason) {
        ObjectInfo existing;
        assert (this.addObjectsPhase.isAllowed()) : "Objects cannot be added at phase: " + this.addObjectsPhase.toString() + " with reason: " + reason;
        if (original == null || original instanceof WordBase) {
            return;
        }
        if (original instanceof Class) {
            throw VMError.shouldNotReachHere("Must not have Class in native image heap: " + original);
        }
        if (original instanceof DynamicHub && ((DynamicHub)original).getClassInitializationInfo() == null) {
            throw VMError.shouldNotReachHere("DynamicHub written to the image that has not been seen as reachable during static analysis: " + original);
        }
        int identityHashCode = 0;
        if (original instanceof HostedIdentityHashCodeProvider) {
            identityHashCode = ((HostedIdentityHashCodeProvider)original).hostedIdentityHashCode();
        }
        if (identityHashCode == 0) {
            identityHashCode = System.identityHashCode(original);
        }
        if (original instanceof String) {
            this.handleImageString((String)original);
        }
        if ((existing = this.objects.get(original)) == null) {
            this.addObjectToBootImageHeap(original, immutableFromParent, identityHashCode, reason);
        }
    }

    public void writeHeap(DebugContext debug, RelocatableBuffer roBuffer, RelocatableBuffer rwBuffer) {
        try (Indent perHeapIndent = debug.logAndIndent("BootImageHeap.writeHeap:");){
            for (ObjectInfo info : this.objects.values()) {
                assert (!this.blacklist.contains(info.getObject()));
                this.writeObject(info, roBuffer, rwBuffer);
            }
            this.writeStaticFields(rwBuffer);
            this.patchPartitionBoundaries(debug, roBuffer, rwBuffer);
        }
        if (NativeImageOptions.PrintHeapHistogram.getValue().booleanValue()) {
            ObjectGroupHistogram.print(this);
            this.readOnlyPrimitive.printHistogram();
            this.readOnlyReference.printHistogram();
            this.readOnlyRelocatable.printHistogram();
            this.writablePrimitive.printHistogram();
            this.writableReference.printHistogram();
        }
        if (NativeImageOptions.PrintImageHeapPartitionSizes.getValue().booleanValue()) {
            this.readOnlyPrimitive.printSize();
            this.readOnlyReference.printSize();
            this.readOnlyRelocatable.printSize();
            this.writablePrimitive.printSize();
            this.writableReference.printSize();
        }
    }

    public ObjectInfo getObjectInfo(Object obj) {
        return this.objects.get(obj);
    }

    private void handleImageString(String str) {
        NativeImageHeap.forceHashCodeComputation(str);
        if (HostedStringDeduplication.isInternedString(str)) {
            assert (this.internedStrings.containsKey(str) || this.internStringsPhase.isAllowed()) : "Should not intern string during phase " + this.internStringsPhase.toString();
            this.internedStrings.put(str, str);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"}, justification="eager hash field computation")
    private static void forceHashCodeComputation(String str) {
        str.hashCode();
    }

    private void addObjectToBootImageHeap(Object object, boolean immutableFromParent, int identityHashCode, Object reason) {
        ObjectInfo info;
        HostedClass clazz;
        Optional<HostedType> optionalType = this.getMetaAccess().optionalLookupJavaType(object.getClass());
        if (!optionalType.isPresent() || !optionalType.get().isInstantiated()) {
            throw UserError.abort("Image heap writing found an object whose class was not seen as instantiated during static analysis. Did a static field or an object referenced from a static field changed during native image generation? For example, a lazily initialized cache could have been initialized during image generation, in which case you need to force eager initialization of the cache before static analysis or reset the cache using a field value recomputation.\n  object: " + object + "  of class: " + object.getClass().getTypeName() + "\n  reachable through:\n" + NativeImageHeap.fillReasonStack(new StringBuilder(), reason));
        }
        HostedType type = optionalType.get();
        DynamicHub hub = type.getHub();
        boolean immutable = immutableFromParent || this.isImmutable(object);
        boolean written = false;
        boolean references = false;
        boolean relocatable = false;
        if (type.isInstanceClass()) {
            long size;
            clazz = (HostedInstanceClass)type;
            if (((HostedInstanceClass)clazz).getMonitorFieldOffset() != 0) {
                immutable = false;
                written = true;
                references = true;
            }
            JavaConstant con = SubstrateObjectConstant.forObject(object);
            HostedField hybridBitsetField = null;
            HostedField hybridArrayField = null;
            Object hybridArray = null;
            if (HybridLayout.isHybrid(clazz)) {
                Object bitSet;
                HybridLayout<Object> hybridLayout = this.hybridLayouts.get(clazz);
                if (hybridLayout == null) {
                    hybridLayout = new HybridLayout((HostedInstanceClass)clazz, this.layout);
                    this.hybridLayouts.put(clazz, hybridLayout);
                }
                if ((hybridBitsetField = hybridLayout.getBitsetField()) != null && (bitSet = NativeImageHeap.readObjectField(hybridBitsetField, con)) != null) {
                    this.blacklist.add(bitSet);
                }
                if ((hybridArray = NativeImageHeap.readObjectField(hybridArrayField = hybridLayout.getArrayField(), con)) != null) {
                    this.blacklist.add(hybridArray);
                    written = true;
                }
                size = hybridLayout.getTotalSize(Array.getLength(hybridArray));
            } else {
                size = LayoutEncoding.getInstanceSize(hub.getLayoutEncoding()).rawValue();
            }
            info = this.addToImageHeap(object, clazz, size, identityHashCode, reason);
            this.recursiveAddObject(hub, false, info);
            boolean fieldsAreImmutable = object instanceof String;
            for (HostedField field : ((HostedInstanceClass)clazz).getInstanceFields(true)) {
                if (!field.isAccessed() || field.equals(hybridArrayField) || field.equals(hybridBitsetField)) continue;
                boolean fieldRelocatable = false;
                if (field.getJavaKind() == JavaKind.Object) {
                    assert (field.hasLocation());
                    JavaConstant fieldValueConstant = field.readValue(con);
                    if (fieldValueConstant.getJavaKind() == JavaKind.Object) {
                        Object fieldValue = SubstrateObjectConstant.asObject((Constant)fieldValueConstant);
                        if (NativeImageHeap.spawnIsolates()) {
                            fieldRelocatable = fieldValue instanceof RelocatedPointer;
                        }
                        this.recursiveAddObject(fieldValue, fieldsAreImmutable, info);
                        references = true;
                    }
                }
                relocatable = relocatable || fieldRelocatable;
                written = written || field.isWritten() && !field.isFinal() && !fieldRelocatable;
            }
            if (hybridArray instanceof Object[]) {
                relocatable = this.addArrayElements((Object[])hybridArray, relocatable, info);
                references = true;
            }
        } else if (type.isArray()) {
            clazz = (HostedArrayClass)type;
            long size = this.layout.getArraySize(type.getComponentType().getStorageKind(), Array.getLength(object));
            info = this.addToImageHeap(object, clazz, size, identityHashCode, reason);
            this.recursiveAddObject(hub, false, info);
            if (object instanceof Object[]) {
                relocatable = this.addArrayElements((Object[])object, false, info);
                references = true;
            }
            written = true;
        } else {
            throw VMError.shouldNotReachHere();
        }
        HeapPartition partition = this.choosePartition(!written || immutable, references, relocatable);
        info.assignToHeapPartition(partition, this.layout);
    }

    private boolean isImmutable(Object obj) {
        if (obj instanceof String) {
            return obj.hashCode() != 0;
        }
        if (obj instanceof DynamicHub) {
            return true;
        }
        return this.knownImmutableObjects.contains(obj);
    }

    private ObjectInfo addToImageHeap(Object object, HostedClass clazz, long size, int identityHashCode, Object reason) {
        ObjectInfo info = new ObjectInfo(object, size, clazz, identityHashCode, reason);
        assert (!this.objects.containsKey(object));
        this.objects.put(object, info);
        return info;
    }

    private HeapPartition choosePartition(boolean immutable, boolean references, boolean relocatable) {
        if (SubstrateOptions.UseOnlyWritableBootImageHeap.getValue().booleanValue()) {
            assert (!NativeImageHeap.spawnIsolates());
            return this.writableReference;
        }
        if (immutable) {
            if (relocatable) {
                return this.readOnlyRelocatable;
            }
            return references ? this.readOnlyReference : this.readOnlyPrimitive;
        }
        VMError.guarantee(!relocatable, "Objects with relocatable pointers must be immutable");
        return references ? this.writableReference : this.writablePrimitive;
    }

    private boolean addArrayElements(Object[] array, boolean otherFieldsRelocatable, Object reason) {
        boolean relocatable = otherFieldsRelocatable;
        for (Object element : array) {
            Object value = this.aUniverse.replaceObject(element);
            if (NativeImageHeap.spawnIsolates()) {
                relocatable = relocatable || value instanceof RelocatedPointer;
            }
            this.recursiveAddObject(value, false, reason);
        }
        return relocatable;
    }

    private void recursiveAddObject(Object original, boolean immutableFromParent, Object reason) {
        if (original != null) {
            this.addObjectWorklist.push(new AddObjectData(original, immutableFromParent, reason));
        }
    }

    private void processAddObjectWorklist() {
        while (!this.addObjectWorklist.isEmpty()) {
            AddObjectData data = this.addObjectWorklist.pop();
            this.addObject(data.original, data.immutableFromParent, data.reason);
        }
    }

    private void writeStaticFields(RelocatableBuffer buffer) {
        ObjectInfo primitiveFields = this.objects.get(StaticFieldsSupport.getStaticPrimitiveFields());
        ObjectInfo objectFields = this.objects.get(StaticFieldsSupport.getStaticObjectFields());
        for (HostedField field : this.getUniverse().getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.isWritten() || !field.isAccessed()) continue;
            ObjectInfo fields = field.getStorageKind() == JavaKind.Object ? objectFields : primitiveFields;
            this.writeField(buffer, fields, field, null, null);
        }
    }

    private int referenceSize() {
        return this.layout.getReferenceSize();
    }

    private void mustBeReferenceAligned(int index) {
        assert (index % this.layout.getReferenceSize() == 0) : "index " + index + " must be reference-aligned.";
    }

    private static void verifyTargetDidNotChange(Object target, Object reason, Object targetInfo) {
        if (targetInfo == null) {
            throw UserError.abort("Static field or an object referenced from a static field changed during native image generation?\n  object:" + target + "  of class: " + target.getClass().getTypeName() + "\n  reachable through:\n" + NativeImageHeap.fillReasonStack(new StringBuilder(), reason));
        }
    }

    private static StringBuilder fillReasonStack(StringBuilder msg, Object reason) {
        if (reason instanceof ObjectInfo) {
            ObjectInfo info = (ObjectInfo)reason;
            msg.append("    object: ").append(info.getObject()).append("  of class: ").append(info.getObject().getClass().getTypeName()).append("\n");
            return NativeImageHeap.fillReasonStack(msg, info.reason);
        }
        return msg.append("    root: ").append(reason).append("\n");
    }

    private void writeField(RelocatableBuffer buffer, ObjectInfo fields, HostedField field, JavaConstant receiver, ObjectInfo info) {
        int index = fields.getIntIndexInSection(field.getLocation());
        JavaConstant value = field.readValue(receiver);
        if (value.getJavaKind() == JavaKind.Object && SubstrateObjectConstant.asObject((Constant)value) instanceof RelocatedPointer) {
            this.addNonDataRelocation(buffer, index, (RelocatedPointer)SubstrateObjectConstant.asObject((Constant)value));
        } else {
            this.write(buffer, index, value, info != null ? info : field);
        }
    }

    private void write(RelocatableBuffer buffer, int index, JavaConstant con, Object reason) {
        if (con.getJavaKind() == JavaKind.Object) {
            this.writeReference(buffer, index, SubstrateObjectConstant.asObject((Constant)con), reason);
        } else {
            NativeImageHeap.writePrimitive(buffer, index, con);
        }
    }

    void writeReference(RelocatableBuffer buffer, int index, Object target, Object reason) {
        assert (!(target instanceof WordBase)) : "word values are not references";
        this.mustBeReferenceAligned(index);
        if (target != null) {
            ObjectInfo targetInfo = this.objects.get(target);
            NativeImageHeap.verifyTargetDidNotChange(target, reason, targetInfo);
            if (NativeImageHeap.useHeapBase()) {
                CompressEncoding compressEncoding = (CompressEncoding)ImageSingletons.lookup(CompressEncoding.class);
                int shift = compressEncoding.getShift();
                this.writeReferenceValue(buffer, index, targetInfo.getOffsetInSection() >>> shift);
            } else {
                this.addDirectRelocationWithoutAddend(buffer, index, this.referenceSize(), target);
            }
        }
    }

    private void writeConstant(RelocatableBuffer buffer, int index, JavaKind kind, Object value, ObjectInfo info) {
        PrimitiveConstant con;
        if (value instanceof RelocatedPointer) {
            this.addNonDataRelocation(buffer, index, (RelocatedPointer)value);
            return;
        }
        if (value instanceof WordBase) {
            con = JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)((WordBase)value).rawValue());
        } else if (value == null && kind == FrameAccess.getWordKind()) {
            con = JavaConstant.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)0L);
        } else {
            assert (kind == JavaKind.Object || value != null) : "primitive value must not be null";
            con = SubstrateObjectConstant.forBoxedValue(kind, value);
        }
        this.write(buffer, index, (JavaConstant)con, info);
    }

    private void writeDynamicHub(RelocatableBuffer buffer, int index, DynamicHub target) {
        assert (target != null) : "Null DynamicHub found during native image generation.";
        this.mustBeReferenceAligned(index);
        ObjectInfo targetInfo = this.objects.get(target);
        assert (targetInfo != null) : "Unknown object " + target.toString() + " found. Static field or an object referenced from a static field changed during native image generation?";
        if (NativeImageHeap.useHeapBase()) {
            long targetOffset = targetInfo.getOffsetInSection();
            long bits = Heap.getHeap().getObjectHeader().setBootImageOnLong(targetOffset);
            this.writeReferenceValue(buffer, index, bits);
        } else {
            long objectHeaderBits = Heap.getHeap().getObjectHeader().setBootImageOnLong(0L);
            this.addDirectRelocationWithAddend(buffer, index, target, objectHeaderBits);
        }
    }

    private void addDirectRelocationWithoutAddend(RelocatableBuffer buffer, int index, int size, Object target) {
        assert (!NativeImageHeap.spawnIsolates() || (long)index >= this.readOnlyRelocatable.offsetInSection() && (long)index < this.readOnlyRelocatable.offsetInSection(this.readOnlyRelocatable.getSize()));
        buffer.addDirectRelocationWithoutAddend(index, size, target);
        if (this.firstRelocatablePointerOffsetInSection == -1L) {
            this.firstRelocatablePointerOffsetInSection = index;
        }
    }

    private void addDirectRelocationWithAddend(RelocatableBuffer buffer, int index, DynamicHub target, long objectHeaderBits) {
        assert (!NativeImageHeap.spawnIsolates() || (long)index >= this.readOnlyRelocatable.offsetInSection() && (long)index < this.readOnlyRelocatable.offsetInSection(this.readOnlyRelocatable.getSize()));
        buffer.addDirectRelocationWithAddend(index, this.referenceSize(), objectHeaderBits, target);
        if (this.firstRelocatablePointerOffsetInSection == -1L) {
            this.firstRelocatablePointerOffsetInSection = index;
        }
    }

    private void addNonDataRelocation(RelocatableBuffer buffer, int index, RelocatedPointer pointer) {
        HostedMethod hMethod;
        this.mustBeReferenceAligned(index);
        assert (pointer instanceof CFunctionPointer) : "unknown relocated pointer " + pointer;
        assert (pointer instanceof MethodPointer) : "cannot create relocation for unknown FunctionPointer " + pointer;
        ResolvedJavaMethod method = ((MethodPointer)pointer).getMethod();
        HostedMethod hostedMethod = hMethod = method instanceof HostedMethod ? (HostedMethod)method : this.universe.lookup((JavaMethod)method);
        if (hMethod.isCodeAddressOffsetValid()) {
            int pointerSize = ConfigurationValues.getTarget().wordSize;
            this.addDirectRelocationWithoutAddend(buffer, index, pointerSize, pointer);
        }
    }

    private static void writePrimitive(RelocatableBuffer buffer, int index, JavaConstant con) {
        ByteBuffer bb = buffer.getBuffer();
        switch (con.getJavaKind()) {
            case Boolean: {
                bb.put(index, (byte)con.asInt());
                break;
            }
            case Byte: {
                bb.put(index, (byte)con.asInt());
                break;
            }
            case Char: {
                bb.putChar(index, (char)con.asInt());
                break;
            }
            case Short: {
                bb.putShort(index, (short)con.asInt());
                break;
            }
            case Int: {
                bb.putInt(index, con.asInt());
                break;
            }
            case Long: {
                bb.putLong(index, con.asLong());
                break;
            }
            case Float: {
                bb.putFloat(index, con.asFloat());
                break;
            }
            case Double: {
                bb.putDouble(index, con.asDouble());
                break;
            }
            default: {
                throw VMError.shouldNotReachHere(con.getJavaKind().toString());
            }
        }
    }

    private void writeReferenceValue(RelocatableBuffer buffer, int index, long value) {
        if (this.referenceSize() == 8) {
            buffer.getBuffer().putLong(index, value);
        } else if (this.referenceSize() == 4) {
            buffer.getBuffer().putInt(index, NumUtil.safeToInt((long)value));
        } else {
            throw VMError.shouldNotReachHere("Unsupported reference size: " + this.referenceSize());
        }
    }

    private void patchPartitionBoundaries(DebugContext debug, RelocatableBuffer roBuffer, RelocatableBuffer rwBuffer) {
        NativeImageInfoPatcher patcher = new NativeImageInfoPatcher(debug, roBuffer, rwBuffer);
        patcher.patchReference("firstReadOnlyPrimitiveObject", this.readOnlyPrimitive.firstAllocatedObject);
        patcher.patchReference("lastReadOnlyPrimitiveObject", this.readOnlyPrimitive.lastAllocatedObject);
        Object firstReadOnlyReferenceObject = this.readOnlyReference.firstAllocatedObject;
        if (firstReadOnlyReferenceObject == null) {
            firstReadOnlyReferenceObject = this.readOnlyRelocatable.firstAllocatedObject;
        }
        patcher.patchReference("firstReadOnlyReferenceObject", firstReadOnlyReferenceObject);
        Object lastReadOnlyReferenceObject = this.readOnlyRelocatable.lastAllocatedObject;
        if (lastReadOnlyReferenceObject == null) {
            lastReadOnlyReferenceObject = this.readOnlyReference.lastAllocatedObject;
        }
        patcher.patchReference("lastReadOnlyReferenceObject", lastReadOnlyReferenceObject);
        patcher.patchReference("firstWritablePrimitiveObject", this.writablePrimitive.firstAllocatedObject);
        patcher.patchReference("lastWritablePrimitiveObject", this.writablePrimitive.lastAllocatedObject);
        patcher.patchReference("firstWritableReferenceObject", this.writableReference.firstAllocatedObject);
        patcher.patchReference("lastWritableReferenceObject", this.writableReference.lastAllocatedObject);
    }

    private static RelocatableBuffer bufferForPartition(ObjectInfo info, RelocatableBuffer roBuffer, RelocatableBuffer rwBuffer) {
        VMError.guarantee(info != null, "[BootImageHeap.bufferForPartition: info is null]");
        VMError.guarantee(info.getPartition() != null, "[BootImageHeap.bufferForPartition: info.partition is null]");
        return info.getPartition().isWritable() ? rwBuffer : roBuffer;
    }

    private void writeObject(ObjectInfo info, RelocatableBuffer roBuffer, RelocatableBuffer rwBuffer) {
        RelocatableBuffer buffer = NativeImageHeap.bufferForPartition(info, roBuffer, rwBuffer);
        int indexInSection = info.getIntIndexInSection(this.layout.getHubOffset());
        assert (this.layout.isAligned(info.getOffsetInPartition()));
        assert (this.layout.isAligned(indexInSection));
        HostedClass clazz = info.getClazz();
        DynamicHub hub = clazz.getHub();
        this.writeDynamicHub(buffer, indexInSection, hub);
        if (clazz.isInstanceClass()) {
            JavaConstant con = SubstrateObjectConstant.forObject(info.getObject());
            HybridLayout<?> hybridLayout = this.hybridLayouts.get(clazz);
            HostedField hybridArrayField = null;
            HostedField hybridBitsetField = null;
            int maxBitIndex = -1;
            Object hybridArray = null;
            if (hybridLayout != null) {
                Object bitSet;
                hybridArrayField = hybridLayout.getArrayField();
                hybridArray = NativeImageHeap.readObjectField(hybridArrayField, con);
                hybridBitsetField = hybridLayout.getBitsetField();
                if (hybridBitsetField != null && (bitSet = (BitSet)NativeImageHeap.readObjectField(hybridBitsetField, con)) != null) {
                    int bitsPerByte = 8;
                    int bit = ((BitSet)bitSet).nextSetBit(0);
                    while (bit >= 0) {
                        int index = info.getIntIndexInSection(hybridLayout.getBitFieldOffset()) + bit / bitsPerByte;
                        if (index > maxBitIndex) {
                            maxBitIndex = index;
                        }
                        int mask = 1 << bit % bitsPerByte;
                        assert (mask < 1 << bitsPerByte);
                        buffer.putByte(index, (byte)(buffer.getByte(index) | mask));
                        bit = ((BitSet)bitSet).nextSetBit(bit + 1);
                    }
                }
            }
            for (HostedField field : clazz.getInstanceFields(true)) {
                if (field.equals(hybridArrayField) || field.equals(hybridBitsetField) || !field.isAccessed()) continue;
                assert (field.getLocation() >= 0);
                assert (info.getIntIndexInSection(field.getLocation()) > maxBitIndex);
                this.writeField(buffer, info, field, con, info);
            }
            if (hub.getHashCodeOffset() != 0) {
                buffer.putInt(info.getIntIndexInSection(hub.getHashCodeOffset()), info.getIdentityHashCode());
            }
            if (hybridArray != null) {
                int length = Array.getLength(hybridArray);
                buffer.putInt(info.getIntIndexInSection(this.layout.getArrayLengthOffset()), length);
                for (int i = 0; i < length; ++i) {
                    int elementIndex = info.getIntIndexInSection(hybridLayout.getArrayElementOffset(i));
                    JavaKind elementStorageKind = hybridLayout.getArrayElementStorageKind();
                    Object array = Array.get(hybridArray, i);
                    this.writeConstant(buffer, elementIndex, elementStorageKind, array, info);
                }
            }
        } else if (clazz.isArray()) {
            JavaKind kind = clazz.getComponentType().getStorageKind();
            Object array = info.getObject();
            int length = Array.getLength(array);
            buffer.putInt(info.getIntIndexInSection(this.layout.getArrayLengthOffset()), length);
            buffer.putInt(info.getIntIndexInSection(this.layout.getArrayHashCodeOffset()), info.getIdentityHashCode());
            if (array instanceof Object[]) {
                Object[] oarray = (Object[])array;
                assert (oarray.length == length);
                for (int i = 0; i < length; ++i) {
                    int elementIndex = info.getIntIndexInSection(this.layout.getArrayElementOffset(kind, i));
                    Object element = this.aUniverse.replaceObject(oarray[i]);
                    assert (oarray[i] instanceof RelocatedPointer == element instanceof RelocatedPointer);
                    this.writeConstant(buffer, elementIndex, kind, element, info);
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    int elementIndex = info.getIntIndexInSection(this.layout.getArrayElementOffset(kind, i));
                    Object element = Array.get(array, i);
                    this.writeConstant(buffer, elementIndex, kind, element, info);
                }
            }
        } else {
            throw VMError.shouldNotReachHere();
        }
    }

    protected HostedUniverse getUniverse() {
        return this.universe;
    }

    protected HostedMetaAccess getMetaAccess() {
        return this.metaAccess;
    }

    public NativeImageHeap(AnalysisUniverse aUniverse, HostedUniverse universe, HostedMetaAccess metaAccess) {
        this.aUniverse = aUniverse;
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.layout = ConfigurationValues.getObjectLayout();
        this.readOnlyPrimitive = HeapPartition.factory("readOnlyPrimitive", this, false);
        this.readOnlyReference = HeapPartition.factory("readOnlyReference", this, false);
        this.readOnlyRelocatable = HeapPartition.factory("readOnlyRelocatable", this, false);
        this.writablePrimitive = HeapPartition.factory("writablePrimitive", this, true);
        this.writableReference = HeapPartition.factory("writableReference", this, true);
        if (NativeImageHeap.useHeapBase()) {
            this.readOnlyPrimitive.incrementSize(this.layout.getAlignment());
        }
    }

    protected static final class Phase {
        private PhaseValue value = PhaseValue.BEFORE;

        public static Phase factory() {
            return new Phase();
        }

        public boolean isBefore() {
            return this.value == PhaseValue.BEFORE;
        }

        public void allow() {
            assert (this.value == PhaseValue.BEFORE) : "Can not allow while in phase " + this.value.toString();
            this.value = PhaseValue.ALLOWED;
        }

        void disallow() {
            assert (this.value == PhaseValue.ALLOWED) : "Can not disallow while in phase " + this.value.toString();
            this.value = PhaseValue.AFTER;
        }

        public boolean isAllowed() {
            return this.value == PhaseValue.ALLOWED;
        }

        public String toString() {
            return this.value.toString();
        }

        protected Phase() {
        }

        private static enum PhaseValue {
            BEFORE,
            ALLOWED,
            AFTER;

        }
    }

    public static final class HeapPartition {
        private final String name;
        private final NativeImageHeap heap;
        private final boolean writable;
        private long size;
        private long count;
        Object firstAllocatedObject;
        Object lastAllocatedObject;
        private String sectionName;
        private long sectionOffset;
        private static final long INVALID_SECTION_OFFSET = -1L;

        static HeapPartition factory(String name, NativeImageHeap heap, boolean writable) {
            return new HeapPartition(name, heap, writable);
        }

        long getSize() {
            return this.size;
        }

        long getCount() {
            return this.count;
        }

        void incrementSize(long increment) {
            this.size += increment;
            ++this.count;
        }

        long allocate(ObjectInfo info) {
            Object object;
            this.lastAllocatedObject = object = info.getObject();
            if (this.firstAllocatedObject == null) {
                this.firstAllocatedObject = object;
            }
            long position = this.size;
            this.incrementSize(info.getSize());
            return position;
        }

        public boolean isWritable() {
            return this.writable;
        }

        void setSection(String name, long offset) {
            this.sectionName = name;
            this.sectionOffset = offset;
            assert (this.heap.layout.isAligned(offset)) : String.format("Partition: %s: offset: %d in section: %s must be aligned.", this.name, this.offsetInSection(), this.getSectionName());
        }

        String getSectionName() {
            assert (this.sectionName != null) : "Partition " + this.name + " should have a section name by now.";
            return this.sectionName;
        }

        long offsetInSection() {
            assert (this.sectionOffset != -1L) : "Partition " + this.name + " should have an offset by now.";
            return this.sectionOffset;
        }

        long offsetInSection(long offset) {
            return this.offsetInSection() + offset;
        }

        public String toString() {
            return this.name;
        }

        void printHistogram() {
            HeapHistogram histogram = new HeapHistogram();
            HashSet<ObjectInfo> uniqueObjectInfo = new HashSet<ObjectInfo>();
            long uniqueCount = 0L;
            long uniqueSize = 0L;
            long canonicalizedCount = 0L;
            long canonicalizedSize = 0L;
            for (ObjectInfo info : this.heap.objects.values()) {
                if (info.getPartition() != this) continue;
                if (uniqueObjectInfo.add(info)) {
                    histogram.add(info, info.getSize());
                    ++uniqueCount;
                    uniqueSize += info.getSize();
                    continue;
                }
                ++canonicalizedCount;
                canonicalizedSize += info.getSize();
            }
            assert (this.getCount() == uniqueCount) : String.format("Incorrect counting: getCount(): %d  uniqueCount: %d", this.getCount(), uniqueCount);
            assert (this.getSize() == uniqueSize) : String.format("Incorrect sizing: getSize(): %d  uniqueSize: %d", this.getCount(), uniqueCount);
            long nonuniqueCount = uniqueCount + canonicalizedCount;
            long nonuniqueSize = uniqueSize + canonicalizedSize;
            double countPercent = 100.0 * ((double)uniqueCount / (double)nonuniqueCount);
            double sizePercent = 100.0 * ((double)uniqueSize / (double)nonuniqueSize);
            histogram.printHeadings(String.format("=== Partition: %s   count: %d / %d = %.1f%%  size: %d / %d = %.1f%% ===", this.name, this.getCount(), nonuniqueCount, countPercent, this.getSize(), nonuniqueSize, sizePercent));
            histogram.print();
        }

        void printSize() {
            System.out.printf("PrintImageHeapPartitionSizes:  partition: %s  size: %d\n", this.name, this.getSize());
        }

        private HeapPartition(String name, NativeImageHeap heap, boolean writable) {
            this.name = name;
            this.heap = heap;
            this.writable = writable;
            this.size = 0L;
            this.count = 0L;
            this.firstAllocatedObject = null;
            this.lastAllocatedObject = null;
            this.sectionName = null;
            this.sectionOffset = -1L;
        }
    }

    public static final class ObjectInfo {
        private final Object object;
        private final HostedClass clazz;
        private final long size;
        private int identityHashCode;
        private HeapPartition partition;
        private long offsetInPartition;
        final Object reason;

        Object getObject() {
            return this.object;
        }

        HostedClass getClazz() {
            return this.clazz;
        }

        private long getOffsetInPartition() {
            return this.offsetInPartition;
        }

        public long getOffsetInSection() {
            return this.getPartition().offsetInSection(this.getOffsetInPartition());
        }

        public long getIndexInSection(long index) {
            assert (index >= 0L && index < this.getSize()) : "Index: " + index + " out of bounds: [0 .. " + this.getSize() + ").";
            return this.getOffsetInSection() + index;
        }

        int getIntIndexInSection(long index) {
            long result = this.getIndexInSection(index);
            return NumUtil.safeToInt((long)result);
        }

        long getSize() {
            return this.size;
        }

        public HeapPartition getPartition() {
            return this.partition;
        }

        int getIdentityHashCode() {
            return this.identityHashCode;
        }

        private void setIdentityHashCode(int identityHashCode) {
            this.identityHashCode = identityHashCode;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(this.getObject().getClass().getName()).append(" -> ");
            Object cur = this.reason;
            Object prev = null;
            boolean skipped = false;
            while (cur instanceof ObjectInfo) {
                skipped = prev != null;
                prev = cur;
                cur = ((ObjectInfo)cur).reason;
            }
            if (skipped) {
                result.append("... -> ");
            }
            if (prev != null) {
                result.append(prev);
            } else {
                result.append(cur);
            }
            return result.toString();
        }

        ObjectInfo(Object object, long size, HostedClass clazz, int identityHashCode, Object reason) {
            this.object = object;
            this.clazz = clazz;
            this.partition = null;
            this.offsetInPartition = -1L;
            this.size = size;
            this.setIdentityHashCode(identityHashCode);
            this.reason = reason;
        }

        void assignToHeapPartition(HeapPartition objectPartition, ObjectLayout layout) {
            assert (this.partition == null);
            this.partition = objectPartition;
            this.offsetInPartition = this.partition.allocate(this);
            assert (layout.isAligned(this.offsetInPartition)) : "start: " + this.offsetInPartition + " must be aligned.";
            assert (layout.isAligned(this.size)) : "size: " + this.size + " must be aligned.";
        }
    }

    static class AddObjectData {
        final Object original;
        final boolean immutableFromParent;
        final Object reason;

        AddObjectData(Object original, boolean immutableFromParent, Object reason) {
            this.original = original;
            this.immutableFromParent = immutableFromParent;
            this.reason = reason;
        }
    }

    private final class NativeImageInfoPatcher {
        private final ObjectInfo staticFieldsInfo;
        private final RelocatableBuffer buffer;
        private final DebugContext debug;

        NativeImageInfoPatcher(DebugContext debugContext, RelocatableBuffer roBuffer, RelocatableBuffer rwBuffer) {
            this.staticFieldsInfo = NativeImageHeap.this.objects.get(StaticFieldsSupport.getStaticObjectFields());
            this.buffer = NativeImageHeap.bufferForPartition(this.staticFieldsInfo, roBuffer, rwBuffer);
            this.debug = debugContext;
        }

        void patchReference(String fieldName, Object fieldValue) {
            if (fieldValue == null) {
                this.debug.log("BootImageHeap.patchPartitionBoundaries: %s is null", (Object)fieldName);
                return;
            }
            try {
                HostedField field = NativeImageHeap.this.getMetaAccess().lookupJavaField(NativeImageInfo.class.getDeclaredField(fieldName));
                int index = this.staticFieldsInfo.getIntIndexInSection(field.getLocation());
                NativeImageHeap.this.writeReference(this.buffer, index, fieldValue, this.staticFieldsInfo);
            }
            catch (NoSuchFieldException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
    }
}

