/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParser;
import com.oracle.svm.hosted.json.JSONParser;
import com.oracle.svm.hosted.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.meta.MetaUtil;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public final class ReflectionConfigurationParser
extends ConfigurationParser {
    private static final String CONSTRUCTOR_NAME = "<init>";
    private final ReflectionRegistry registry;

    public ReflectionConfigurationParser(ReflectionRegistry registry, ImageClassLoader classLoader) {
        super(classLoader);
        this.registry = registry;
    }

    @Override
    protected void parseAndRegister(Reader reader, String featureName, Object location, HostedOptionKey<String> option) {
        try {
            JSONParser parser = new JSONParser(reader);
            Object json = parser.parse();
            this.parseClassArray(ReflectionConfigurationParser.asList(json, "first level of document must be an array of class descriptors"));
        }
        catch (JSONParserException | IOException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null || errorMessage.isEmpty()) {
                errorMessage = e.toString();
            }
            throw UserError.abort("Error parsing " + featureName + " configuration in " + location + ":\n" + errorMessage + "\nVerify that the configuration matches the schema described in the " + SubstrateOptionsParser.commandArgument(SubstrateOptions.PrintFlags, "+") + " output for option " + option.getName() + ".");
        }
    }

    private void parseClassArray(List<Object> classes) {
        for (Object clazz : classes) {
            this.parseClass(ReflectionConfigurationParser.asMap(clazz, "second level of document must be class descriptor objects"));
        }
    }

    private void parseClass(Map<String, Object> data) {
        Object classObject = data.get("name");
        if (classObject == null) {
            throw new JSONParserException("Missing atrribute 'name' in class descriptor object");
        }
        String className = ReflectionConfigurationParser.asString(classObject, "name");
        Class<?> clazz = this.classLoader.findClassByName(className, false);
        if (clazz == null) {
            throw new JSONParserException("Class " + className + " not found");
        }
        this.registry.register(new Class[]{clazz});
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (name.equals("name")) continue;
            if (name.equals("allDeclaredConstructors")) {
                if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredConstructors")) continue;
                this.registry.register((Executable[])clazz.getDeclaredConstructors());
                continue;
            }
            if (name.equals("allPublicConstructors")) {
                if (!ReflectionConfigurationParser.asBoolean(value, "allPublicConstructors")) continue;
                this.registry.register((Executable[])clazz.getConstructors());
                continue;
            }
            if (name.equals("allDeclaredMethods")) {
                if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredMethods")) continue;
                this.registry.register((Executable[])clazz.getDeclaredMethods());
                continue;
            }
            if (name.equals("allPublicMethods")) {
                if (!ReflectionConfigurationParser.asBoolean(value, "allPublicMethods")) continue;
                this.registry.register((Executable[])clazz.getMethods());
                continue;
            }
            if (name.equals("allDeclaredFields")) {
                if (!ReflectionConfigurationParser.asBoolean(value, "allDeclaredFields")) continue;
                this.registry.register(clazz.getDeclaredFields());
                continue;
            }
            if (name.equals("allPublicFields")) {
                if (!ReflectionConfigurationParser.asBoolean(value, "allPublicFields")) continue;
                this.registry.register(clazz.getFields());
                continue;
            }
            if (name.equals("methods")) {
                this.parseMethods(ReflectionConfigurationParser.asList(value, "Attribute 'methods' must be an array of method descriptors"), clazz);
                continue;
            }
            if (name.equals("fields")) {
                this.parseFields(ReflectionConfigurationParser.asList(value, "Attribute 'fields' must be an array of field descriptors"), clazz);
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + name + "' (supported attributes: allDeclaredConstructors, allPublicConstructors, allDeclaredMethods, allPublicMethods, allDeclaredFields, allPublicFields, methods, fields) in defintion of class " + clazz.getTypeName());
        }
    }

    private void parseFields(List<Object> fields, Class<?> clazz) {
        for (Object field : fields) {
            this.parseField(ReflectionConfigurationParser.asMap(field, "Elements of 'fields' array must be field descriptor objects"), clazz);
        }
    }

    private void parseField(Map<String, Object> data, Class<?> clazz) {
        String fieldName = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String propertyName = entry.getKey();
            if (propertyName.equals("name")) {
                fieldName = ReflectionConfigurationParser.asString(entry.getValue(), "name");
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + propertyName + "' (supported attributes: 'name') in definition of field for class '" + clazz.getTypeName() + "'");
        }
        if (fieldName == null) {
            throw new JSONParserException("Missing atribute 'name' in definition of field for class " + clazz.getTypeName());
        }
        try {
            this.registry.register(new Field[]{clazz.getDeclaredField(fieldName)});
        }
        catch (NoSuchFieldException e) {
            throw new JSONParserException("Field " + clazz.getTypeName() + "." + fieldName + " not found");
        }
    }

    private void parseMethods(List<Object> methods, Class<?> clazz) {
        for (Object method : methods) {
            this.parseMethod(ReflectionConfigurationParser.asMap(method, "Elements of 'methods' array must be method descriptor objects"), clazz);
        }
    }

    private void parseMethod(Map<String, Object> data, Class<?> clazz) {
        String methodName = null;
        Class<?>[] methodParameterTypes = null;
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String propertyName = entry.getKey();
            if (propertyName.equals("name")) {
                methodName = ReflectionConfigurationParser.asString(entry.getValue(), "name");
                continue;
            }
            if (propertyName.equals("parameterTypes")) {
                methodParameterTypes = this.parseTypes(ReflectionConfigurationParser.asList(entry.getValue(), "Attribute 'parameterTypes' must be a list of type names"));
                continue;
            }
            throw new JSONParserException("Unknown attribute '" + propertyName + "' (supported attributes: 'name', 'parameterTypes') in definition of method for class '" + clazz.getTypeName() + "'");
        }
        if (methodName == null) {
            throw new JSONParserException("Missing attribute 'name' in definition of method for class '" + clazz.getTypeName() + "'");
        }
        if (methodParameterTypes != null) {
            try {
                Executable method = CONSTRUCTOR_NAME.equals(methodName) ? clazz.getDeclaredConstructor(methodParameterTypes) : clazz.getDeclaredMethod(methodName, methodParameterTypes);
                this.registry.register(new Executable[]{method});
            }
            catch (NoSuchMethodException e) {
                String parameterTypeNames = Stream.of(methodParameterTypes).map(Class::getSimpleName).collect(Collectors.joining(", "));
                throw new JSONParserException("Method " + clazz.getTypeName() + "." + methodName + "(" + parameterTypeNames + ") not found");
            }
        } else {
            Executable[] methods;
            boolean found = false;
            boolean isConstructor = CONSTRUCTOR_NAME.equals(methodName);
            for (Executable method : methods = isConstructor ? clazz.getDeclaredConstructors() : clazz.getDeclaredMethods()) {
                if (!isConstructor && !method.getName().equals(methodName)) continue;
                this.registry.register(new Executable[]{method});
                found = true;
            }
            if (!found) {
                throw new JSONParserException("Method " + clazz.getTypeName() + "." + methodName + " not found");
            }
        }
    }

    private Class<?>[] parseTypes(List<Object> types) {
        ArrayList result = new ArrayList();
        for (Object type : types) {
            Class<?> clazz;
            String typeName = ReflectionConfigurationParser.asString(type, "types");
            if (typeName.indexOf(91) != -1) {
                typeName = MetaUtil.internalNameToJava((String)MetaUtil.toInternalName((String)typeName), (boolean)true, (boolean)true);
            }
            if ((clazz = this.classLoader.findClassByName(typeName, false)) == null) {
                throw new JSONParserException("Class " + typeName + " not found");
            }
            result.add(clazz);
        }
        return result.toArray(new Class[result.size()]);
    }
}

