/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.config;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParser;
import com.oracle.svm.hosted.json.JSONParser;
import com.oracle.svm.hosted.json.JSONParserException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public final class ProxyConfigurationParser
extends ConfigurationParser {
    private final DynamicProxyRegistry dynamicProxyRegistry;

    public ProxyConfigurationParser(ImageClassLoader classLoader, DynamicProxyRegistry dynamicProxyRegistry) {
        super(classLoader);
        this.dynamicProxyRegistry = dynamicProxyRegistry;
    }

    @Override
    protected void parseAndRegister(Reader reader, String featureName, Object location, HostedOptionKey<String> option) {
        try {
            JSONParser parser = new JSONParser(reader);
            Object json = parser.parse();
            this.parseTopLevelArray(ProxyConfigurationParser.asList(json, "first level of document must be an array of interface lists"));
        }
        catch (JSONParserException | IOException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null || errorMessage.isEmpty()) {
                errorMessage = e.toString();
            }
            throw UserError.abort("Error parsing " + featureName + " configuration in " + location + ":\n" + errorMessage + "\nVerify that the configuration matches the schema described in the " + SubstrateOptionsParser.commandArgument(SubstrateOptions.PrintFlags, "+") + " output for option " + option.getName() + ".");
        }
    }

    private void parseTopLevelArray(List<Object> interfaceLists) {
        for (Object interfaceList : interfaceLists) {
            this.parseInterfaceList(ProxyConfigurationParser.asList(interfaceList, "second level of document must be a lists of objects"));
        }
    }

    private void parseInterfaceList(List<?> data) {
        ArrayList interfaces = new ArrayList();
        for (Object value : data) {
            String className = ProxyConfigurationParser.asString(value);
            Class<?> clazz = this.classLoader.findClassByName(className, false);
            if (clazz == null) {
                throw new JSONParserException("Class " + className + " not found");
            }
            if (!clazz.isInterface()) {
                throw new JSONParserException("The class \"" + className + "\" is not an interface.");
            }
            interfaces.add(clazz);
        }
        this.dynamicProxyRegistry.addProxyClass(interfaces.toArray(new Class[0]));
    }
}

