/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.GraalConfiguration;
import com.oracle.svm.core.graal.code.amd64.SubstrateAMD64RegisterConfig;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateCodeCacheProvider;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.meta.SubstrateLoweringProvider;
import com.oracle.svm.core.graal.meta.SubstrateSnippetReflectionProvider;
import com.oracle.svm.core.graal.meta.SubstrateStampProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.config.HybridLayout;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import java.util.EnumMap;
import java.util.function.Function;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.nodes.spi.LoweringProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.word.WordTypes;

public abstract class SharedRuntimeConfigurationBuilder {
    protected final OptionValues options;
    protected final SVMHost hostVM;
    protected final MetaAccessProvider metaAccess;
    protected RuntimeConfiguration runtimeConfig;
    protected WordTypes wordTypes;
    protected Function<Providers, Backend> backendProvider;

    public SharedRuntimeConfigurationBuilder(OptionValues options, SVMHost hostVM, MetaAccessProvider metaAccess, Function<Providers, Backend> backendProvider) {
        this.options = options;
        this.hostVM = hostVM;
        this.metaAccess = metaAccess;
        this.backendProvider = backendProvider;
    }

    public SharedRuntimeConfigurationBuilder build() {
        this.wordTypes = new WordTypes(this.metaAccess, FrameAccess.getWordKind());
        Providers p = this.createProviders(null, null, null, null, null, null, null, null);
        StampProvider stampProvider = this.createStampProvider(p);
        p = this.createProviders(null, null, null, null, null, null, stampProvider, null);
        ConstantReflectionProvider constantReflection = this.createConstantReflectionProvider(p);
        p = this.createProviders(null, constantReflection, null, null, null, null, stampProvider, null);
        ConstantFieldProvider constantFieldProvider = this.createConstantFieldProvider(p);
        SnippetReflectionProvider snippetReflection = this.createSnippetReflectionProvider();
        ForeignCallsProvider foreignCalls = this.createForeignCallsProvider();
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, null, null, stampProvider, snippetReflection);
        LoweringProvider lowerer = this.createLoweringProvider(p);
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, lowerer, null, stampProvider, snippetReflection);
        Replacements replacements = this.createReplacements(p, snippetReflection);
        p = this.createProviders(null, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, snippetReflection);
        EnumMap<SubstrateAMD64RegisterConfig.ConfigKind, Backend> backends = new EnumMap<SubstrateAMD64RegisterConfig.ConfigKind, Backend>(SubstrateAMD64RegisterConfig.ConfigKind.class);
        for (SubstrateAMD64RegisterConfig.ConfigKind config : SubstrateAMD64RegisterConfig.ConfigKind.values()) {
            SubstrateAMD64RegisterConfig registerConfig = new SubstrateAMD64RegisterConfig(config, this.metaAccess, ConfigurationValues.getTarget());
            SubstrateCodeCacheProvider codeCacheProvider = this.createCodeCacheProvider(registerConfig);
            Providers newProviders = this.createProviders(codeCacheProvider, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider, snippetReflection);
            backends.put(config, GraalConfiguration.instance().createBackend(newProviders));
        }
        this.runtimeConfig = new RuntimeConfiguration(p, snippetReflection, backends, this.wordTypes);
        return this;
    }

    public WordTypes getWordTypes() {
        return this.wordTypes;
    }

    protected Providers createProviders(CodeCacheProvider codeCache, ConstantReflectionProvider constantReflection, ConstantFieldProvider constantFieldProvider, ForeignCallsProvider foreignCalls, LoweringProvider lowerer, Replacements replacements, StampProvider stampProvider, SnippetReflectionProvider snippetReflection) {
        return new Providers(this.metaAccess, codeCache, constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, stampProvider);
    }

    public RuntimeConfiguration getRuntimeConfig() {
        return this.runtimeConfig;
    }

    protected StampProvider createStampProvider(Providers p) {
        return new SubstrateStampProvider(p.getMetaAccess());
    }

    protected abstract ConstantReflectionProvider createConstantReflectionProvider(Providers var1);

    protected abstract ConstantFieldProvider createConstantFieldProvider(Providers var1);

    protected SnippetReflectionProvider createSnippetReflectionProvider() {
        return new SubstrateSnippetReflectionProvider();
    }

    protected ForeignCallsProvider createForeignCallsProvider() {
        return new SubstrateForeignCallsProvider();
    }

    protected LoweringProvider createLoweringProvider(Providers p) {
        return SubstrateLoweringProvider.create(p.getMetaAccess(), p.getForeignCalls());
    }

    protected abstract Replacements createReplacements(Providers var1, SnippetReflectionProvider var2);

    protected SubstrateCodeCacheProvider createCodeCacheProvider(RegisterConfig registerConfig) {
        return new SubstrateCodeCacheProvider(ConfigurationValues.getTarget(), registerConfig);
    }

    public void updateLazyState(HostedMetaAccess hMetaAccess) {
        int componentHubOffset;
        HybridLayout<DynamicHub> hubLayout = new HybridLayout<DynamicHub>(DynamicHub.class, ConfigurationValues.getObjectLayout(), hMetaAccess);
        int vtableBaseOffset = hubLayout.getArrayBaseOffset();
        int vtableEntrySize = ConfigurationValues.getObjectLayout().sizeInBytes(hubLayout.getArrayElementStorageKind());
        int instanceOfBitsOffset = hubLayout.getBitFieldOffset();
        try {
            componentHubOffset = hMetaAccess.lookupJavaField(DynamicHub.class.getDeclaredField("componentHub")).getLocation();
        }
        catch (NoSuchFieldException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
        this.runtimeConfig.setLazyState(vtableBaseOffset, vtableEntrySize, instanceOfBitsOffset, componentHubOffset);
    }
}

