/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.function;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointPrologueBailoutNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.nodes.ReadRegisterFixedNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.WordBase;

@AutomaticFeature
public class CEntryPointSupport
implements GraalFeature {
    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, InvocationPlugins invocationPlugins, boolean analysis, boolean hosted) {
        CEntryPointSupport.registerEntryPointActionsPlugins(invocationPlugins);
        CEntryPointSupport.registerCurrentIsolatePlugins(invocationPlugins);
    }

    private static void registerEntryPointActionsPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CEntryPointActions.class);
        r.register1("enterCreateIsolate", CEntryPointCreateIsolateParameters.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode parameters) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointEnterNode(CEntryPointEnterNode.EnterAction.CreateIsolate, parameters));
                return true;
            }
        });
        r.register1("enterAttachThread", Isolate.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointEnterNode(CEntryPointEnterNode.EnterAction.AttachThread, isolate));
                return true;
            }
        });
        r.register1("enter", IsolateThread.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode thread) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointEnterNode(CEntryPointEnterNode.EnterAction.Enter, thread));
                return true;
            }
        });
        r.register1("enterIsolate", Isolate.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointEnterNode(CEntryPointEnterNode.EnterAction.EnterIsolate, isolate));
                return true;
            }
        });
        InvocationPlugin bailoutPlugin = new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value) {
                b.add((ValueNode)new CEntryPointPrologueBailoutNode(value));
                return true;
            }
        };
        r.register1("bailoutInPrologue", WordBase.class, bailoutPlugin);
        r.register1("bailoutInPrologue", Long.TYPE, bailoutPlugin);
        r.register1("bailoutInPrologue", Double.TYPE, bailoutPlugin);
        r.register1("bailoutInPrologue", Boolean.TYPE, bailoutPlugin);
        r.register0("bailoutInPrologue", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.add((ValueNode)new CEntryPointPrologueBailoutNode(null));
                return true;
            }
        });
        r.register0("leave", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.Leave));
                return true;
            }
        });
        r.register0("leaveDetachThread", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.DetachThread));
                return true;
            }
        });
        r.register0("leaveTearDownIsolate", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Int, (ValueNode)new CEntryPointLeaveNode(CEntryPointLeaveNode.LeaveAction.TearDownIsolate));
                return true;
            }
        });
        r.register2("failFatally", Integer.TYPE, CCharPointer.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                b.add((ValueNode)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.FailFatally, arg1, arg2));
                return true;
            }
        });
        r.register1("isCurrentThreadAttachedTo", Isolate.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode isolate) {
                b.addPush(JavaKind.Boolean, (ValueNode)new CEntryPointUtilityNode(CEntryPointUtilityNode.UtilityAction.IsAttached, isolate));
                return true;
            }
        });
    }

    private static void registerCurrentIsolatePlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, CurrentIsolate.class);
        r.register0("getCurrentThread", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                    b.addPush(JavaKind.Object, (ValueNode)ReadRegisterFixedNode.forIsolateThread());
                } else if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                    ValueNode heapBase = b.add((ValueNode)ReadRegisterFixedNode.forHeapBase());
                    ConstantNode addend = (ConstantNode)b.add((ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)1575L));
                    b.addPush(JavaKind.Object, (ValueNode)new AddNode(heapBase, (ValueNode)addend));
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)CEntryPointSetup.SINGLE_THREAD_SENTINEL.rawValue()));
                }
                return true;
            }
        });
        r.register0("getIsolate", new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                    b.addPush(JavaKind.Object, (ValueNode)ReadRegisterFixedNode.forHeapBase());
                } else {
                    b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forIntegerKind((JavaKind)FrameAccess.getWordKind(), (long)CEntryPointSetup.SINGLE_ISOLATE_SENTINEL.rawValue()));
                }
                return true;
            }
        });
    }
}

