/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.svm.hosted.analysis.Inflation;
import java.lang.reflect.Modifier;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.nodes.ValueNode;

public class SVMTypeState {
    public static TypeState forPinned(Inflation bb, ValueNode allocation, BytecodeLocation allocationLabel, AnalysisType exactType) {
        return SVMTypeState.forPinned(bb, allocation, allocationLabel, exactType, bb.contextPolicy().emptyContext());
    }

    public static TypeState forPinned(Inflation bb, ValueNode allocation, BytecodeLocation allocationLabel, AnalysisType objectType, AnalysisContext allocationContext) {
        assert (objectType.isArray() || objectType.isInstanceClass() && !Modifier.isAbstract(objectType.getModifiers())) : objectType;
        assert (allocation.getStackKind() == JavaKind.Object);
        AnalysisObject pinnedObject = bb.svmAnalysisPolicy().createPinnedObject(bb, objectType, allocationLabel, allocationContext);
        return TypeState.forNonNullObject((BigBang)bb, (AnalysisObject)pinnedObject);
    }
}

