/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.stack;

import com.oracle.svm.core.amd64.FrameAccess;
import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.stack.JavaFrameAnchor;
import com.oracle.svm.core.stack.JavaFrameAnchors;
import com.oracle.svm.core.stack.StackFrameVisitor;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public final class JavaStackWalker {
    private JavaStackWalker() {
    }

    @AlwaysInline(value="avoid virtual call to visitor")
    public static boolean walkCurrentThread(Pointer startSP, CodePointer startIP, StackFrameVisitor visitor) {
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor();
        return JavaStackWalker.doWalk(anchor, startSP, startIP, visitor);
    }

    @AlwaysInline(value="avoid virtual call to visitor")
    public static boolean walkThread(IsolateThread thread, StackFrameVisitor visitor) {
        JavaFrameAnchor anchor = JavaFrameAnchors.getFrameAnchor(thread);
        Pointer sp = (Pointer)WordFactory.nullPointer();
        CodePointer ip = (CodePointer)WordFactory.nullPointer();
        if (anchor.isNonNull()) {
            sp = anchor.getLastJavaSP();
            ip = FrameAccess.readReturnAddress(sp);
        }
        return JavaStackWalker.doWalk(anchor, sp, ip, visitor);
    }

    @AlwaysInline(value="avoid virtual call to visitor")
    private static boolean doWalk(JavaFrameAnchor lastAnchor, Pointer startSP, CodePointer startIP, StackFrameVisitor visitor) {
        if (!visitor.prologue()) {
            return false;
        }
        if (startSP.isNonNull() && startIP.isNonNull()) {
            JavaFrameAnchor anchor = lastAnchor;
            Pointer sp = startSP;
            CodePointer ip = startIP;
            while (true) {
                if (anchor.isNonNull() && anchor.getLastJavaSP().belowOrEqual((UnsignedWord)sp)) {
                    anchor = anchor.getPreviousAnchor();
                    continue;
                }
                DeoptimizedFrame deoptFrame = Deoptimizer.checkDeoptimized(sp);
                long totalFrameSize = deoptFrame != null ? deoptFrame.getSourceTotalFrameSize() : CodeInfoTable.lookupTotalFrameSize(ip);
                if (totalFrameSize != -1L) {
                    if (!visitor.visitFrame(sp, ip, deoptFrame)) {
                        return false;
                    }
                    sp = sp.add(WordFactory.unsigned((long)totalFrameSize));
                    ip = FrameAccess.readReturnAddress(sp);
                    continue;
                }
                if (!anchor.isNonNull()) break;
                assert (anchor.getLastJavaSP().aboveThan((UnsignedWord)sp));
                sp = anchor.getLastJavaSP();
                ip = FrameAccess.readReturnAddress(sp);
                anchor = anchor.getPreviousAnchor();
            }
        }
        return visitor.epilogue();
    }
}

