/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.PosixVirtualMemoryProvider;
import com.oracle.svm.core.posix.headers.Mman;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public class LinuxVirtualMemoryProvider
extends PosixVirtualMemoryProvider {
    @Override
    @Uninterruptible(reason="May be called from uninterruptible code.", mayBeInlined=true)
    public Pointer commit(PointerBase start, UnsignedWord nbytes, int access) {
        if (start.isNull() && (access & 4) != 0) {
            int flags = Mman.MAP_ANON() | Mman.MAP_PRIVATE() | Mman.MAP_32BIT();
            Pointer result = Mman.NoTransitions.mmap(WordFactory.nullPointer(), nbytes, LinuxVirtualMemoryProvider.accessAsProt(access), flags, -1, 0L);
            if (result.notEqual((ComparableWord)Mman.MAP_FAILED())) {
                return result;
            }
        }
        return super.commit(start, nbytes, access);
    }
}

