/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.function.InvokeCFunctionPointer;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
public class Signal {
    @CFunction
    public static native int kill(int var0, int var1);

    @CFunction
    public static native int sigprocmask(int var0, sigset_tPointer var1, sigset_tPointer var2);

    @CFunction
    public static native SignalDispatcher signal(int var0, SignalDispatcher var1);

    @CConstant
    public static native SignalDispatcher SIG_DFL();

    @CConstant
    public static native SignalDispatcher SIG_IGN();

    @CConstant
    public static native SignalDispatcher SIG_ERR();

    @CFunction
    public static native int raise(int var0);

    @Platforms(value={Platform.LINUX.class})
    @CConstant
    public static native int SA_SIGINFO();

    @CFunction
    public static native int sigaction(SignalEnum var0, sigaction var1, sigaction var2);

    @CFunction
    public static native int sigemptyset(sigset_tPointer var0);

    @Platforms(value={Platform.DARWIN.class})
    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum DarwinSignalEnum {
        SIGINFO,
        SIGEMT;


        @CEnumValue
        public native int getCValue();
    }

    @Platforms(value={Platform.LINUX.class})
    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum LinuxSignalEnum {
        SIGPOLL,
        SIGPWR;


        @CEnumValue
        public native int getCValue();
    }

    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum SignalEnum {
        SIGABRT,
        SIGALRM,
        SIGBUS,
        SIGCHLD,
        SIGCONT,
        SIGFPE,
        SIGHUP,
        SIGILL,
        SIGINT,
        SIGIO,
        SIGIOT,
        SIGKILL,
        SIGPIPE,
        SIGPROF,
        SIGQUIT,
        SIGSEGV,
        SIGSTOP,
        SIGSYS,
        SIGTERM,
        SIGTRAP,
        SIGTSTP,
        SIGTTIN,
        SIGTTOU,
        SIGURG,
        SIGUSR1,
        SIGUSR2,
        SIGVTALRM,
        SIGWINCH,
        SIGXCPU,
        SIGXFSZ;


        @CEnumValue
        public native int getCValue();
    }

    @CStruct(addStructKeyword=true)
    public static interface sigaction
    extends PointerBase {
        @CField
        public SignalDispatcher sa_handler();

        @CField
        public void sa_handler(SignalDispatcher var1);

        @CField
        public AdvancedSignalDispatcher sa_sigaction();

        @CField
        public void sa_sigaction(AdvancedSignalDispatcher var1);

        @CField
        public int sa_flags();

        @CField
        public void sa_flags(int var1);

        @CFieldAddress
        public sigset_tPointer sa_mask();
    }

    public static interface AdvancedSignalDispatcher
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void dispatch(int var1, siginfo_t var2, WordPointer var3);
    }

    @Platforms(value={Platform.LINUX.class})
    @CStruct
    public static interface ucontext_t
    extends PointerBase {
        @CFieldAddress(value="uc_mcontext.gregs")
        public GregsPointer uc_mcontext_gregs();
    }

    @Platforms(value={Platform.LINUX.class})
    @CEnum
    @CContext(value=PosixDirectives.class)
    public static enum GregEnum {
        REG_R8,
        REG_R9,
        REG_R10,
        REG_R11,
        REG_R12,
        REG_R13,
        REG_R14,
        REG_R15,
        REG_RDI,
        REG_RSI,
        REG_RBP,
        REG_RBX,
        REG_RDX,
        REG_RAX,
        REG_RCX,
        REG_RSP,
        REG_RIP,
        REG_EFL,
        REG_CSGSFS,
        REG_ERR,
        REG_TRAPNO,
        REG_OLDMASK,
        REG_CR2;


        @CEnumValue
        public native int getCValue();
    }

    @Platforms(value={Platform.LINUX.class})
    @CPointerTo(nameOfCType="long long int")
    public static interface GregsPointer
    extends PointerBase {
        public long read(int var1);
    }

    @CStruct
    public static interface siginfo_t
    extends PointerBase {
    }

    public static interface SignalDispatcher
    extends CFunctionPointer {
        @InvokeCFunctionPointer
        public void dispatch(int var1);
    }

    @CPointerTo(nameOfCType="sigset_t")
    public static interface sigset_tPointer
    extends PointerBase {
    }
}

