/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;

@CContext(value=PosixDirectives.class)
public class Mman {
    @CConstant
    public static native int PROT_READ();

    @CConstant
    public static native int PROT_WRITE();

    @CConstant
    public static native int PROT_EXEC();

    @CConstant
    public static native int PROT_NONE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PROT_GROWSDOWN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int PROT_GROWSUP();

    @CConstant
    public static native int MAP_SHARED();

    @CConstant
    public static native int MAP_PRIVATE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_TYPE();

    @CConstant
    public static native int MAP_FIXED();

    @CConstant
    public static native int MAP_FILE();

    public static int MAP_ANONYMOUS() {
        return Mman.MAP_ANON();
    }

    @CConstant
    public static native int MAP_ANON();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_32BIT();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_GROWSDOWN();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_DENYWRITE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_EXECUTABLE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_LOCKED();

    @CConstant
    public static native int MAP_NORESERVE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_POPULATE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MAP_NONBLOCK();

    @CConstant
    public static native int MS_ASYNC();

    @CConstant
    public static native int MS_SYNC();

    @CConstant
    public static native int MS_INVALIDATE();

    @CConstant
    public static native int MCL_CURRENT();

    @CConstant
    public static native int MCL_FUTURE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MREMAP_MAYMOVE();

    @CConstant
    @Platforms(value={Platform.LINUX.class})
    public static native int MREMAP_FIXED();

    @CConstant
    public static native int MADV_NORMAL();

    @CConstant
    public static native int MADV_RANDOM();

    @CConstant
    public static native int MADV_SEQUENTIAL();

    @CConstant
    public static native int MADV_WILLNEED();

    @CConstant
    public static native int MADV_DONTNEED();

    @CConstant
    public static native int POSIX_MADV_NORMAL();

    @CConstant
    public static native int POSIX_MADV_RANDOM();

    @CConstant
    public static native int POSIX_MADV_SEQUENTIAL();

    @CConstant
    public static native int POSIX_MADV_WILLNEED();

    @CConstant
    public static native int POSIX_MADV_DONTNEED();

    @CConstant
    public static native PointerBase MAP_FAILED();

    @CFunction
    public static native Pointer mmap(PointerBase var0, UnsignedWord var1, int var2, int var3, int var4, long var5);

    @CFunction
    public static native int munmap(PointerBase var0, UnsignedWord var1);

    @CFunction
    public static native int mprotect(PointerBase var0, UnsignedWord var1, int var2);

    @CFunction
    public static native int msync(PointerBase var0, UnsignedWord var1, int var2);

    @CFunction
    public static native int madvise(PointerBase var0, UnsignedWord var1, int var2);

    @CFunction
    public static native int posix_madvise(PointerBase var0, UnsignedWord var1, int var2);

    @CFunction
    public static native int mlock(PointerBase var0, UnsignedWord var1);

    @CFunction
    public static native int munlock(PointerBase var0, UnsignedWord var1);

    @CFunction
    public static native int mlockall(int var0);

    @CFunction
    public static native int munlockall();

    @CFunction
    public static native int mincore(PointerBase var0, UnsignedWord var1, CCharPointer var2);

    @CFunction
    public static native PointerBase mremap(PointerBase var0, UnsignedWord var1, UnsignedWord var2, int var3, PointerBase var4);

    @CFunction
    public static native int remap_file_pages(PointerBase var0, UnsignedWord var1, int var2, UnsignedWord var3, int var4);

    @CFunction
    public static native int shm_open(CCharPointer var0, int var1, int var2);

    @CFunction
    public static native int shm_unlink(CCharPointer var0);

    public static class NoTransitions {
        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native Pointer mmap(PointerBase var0, UnsignedWord var1, int var2, int var3, int var4, long var5);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int munmap(PointerBase var0, UnsignedWord var1);

        @CFunction(transition=CFunction.Transition.NO_TRANSITION)
        public static native int mprotect(PointerBase var0, UnsignedWord var1, int var2);
    }
}

