/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.posix.PosixVirtualMemoryProvider;
import com.oracle.svm.core.posix.linux.LinuxVirtualMemoryProvider;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;

@AutomaticFeature
class PosixVirtualMemoryProviderFeature
implements Feature {
    PosixVirtualMemoryProviderFeature() {
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        if (!ImageSingletons.contains(VirtualMemoryProvider.class)) {
            PosixVirtualMemoryProvider provider = Platform.includedIn(Platform.LINUX.class) ? new LinuxVirtualMemoryProvider() : new PosixVirtualMemoryProvider();
            ImageSingletons.add(VirtualMemoryProvider.class, (Object)provider);
        }
    }
}

